/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.css.om;

import com.ibm.vida.rave.core.css.CSSStyleDeclaration;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.css.om.CSSValue;
import java.util.ArrayList;
import java.util.List;

public final class CSSStyleDeclarationImpl
extends CSSStyleDeclaration {
    private final List<String> propNames = new ArrayList<String>();
    private final OMap<String, CSSValue> cssValues = new OMap();
    private final List<PropertyValueStruct> propValues = new ArrayList<PropertyValueStruct>();

    @Override
    public String getPropertyValue(String propertyName) {
        int index = this.propNames.indexOf(propertyName);
        return index >= 0 ? this.propValues.get((int)index).value : "";
    }

    public void setPropertyCSSValue(String propertyName, CSSValue value) {
        this.cssValues.put(propertyName, value);
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        return this.cssValues.get(propertyName);
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        int index = this.propNames.indexOf(propertyName);
        if (index == -1) {
            return null;
        }
        return this.propValues.get((int)index).priority ? "important" : "";
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) {
        PropertyValueStruct property = this.findOrCreateProperty(propertyName);
        property.value = value;
        property.priority = "important".equals(priority);
    }

    private PropertyValueStruct findOrCreateProperty(String propertyName) {
        PropertyValueStruct property;
        int index = this.propNames.indexOf(propertyName);
        if (index >= 0) {
            property = this.propValues.get(index);
        } else {
            this.propNames.add(propertyName);
            property = new PropertyValueStruct();
            this.propValues.add(property);
        }
        return property;
    }

    @Override
    public int length() {
        return this.propNames.size();
    }

    @Override
    public String item(int index) {
        return this.propNames.get(index);
    }

    public void each(CSSValue.CSSValueHandler cssValueHandler) {
        int i = 0;
        for (String name : this.propNames) {
            cssValueHandler.handle(name, this.getPropertyCSSValue(name), i++);
        }
    }

    private class PropertyValueStruct {
        String value;
        boolean priority;

        private PropertyValueStruct() {
        }
    }
}

