/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.css.om;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.css.om.CSSValueList;

public class CSSTransformValue
extends CSSValueList {
    public static final int CSS_TRANSLATE = 1;
    public static final int CSS_TRANSLATEX = 2;
    public static final int CSS_TRANSLATEY = 3;
    public static final int CSS_ROTATE = 4;
    public static final int CSS_SCALE = 5;
    public static final int CSS_SCALEX = 6;
    public static final int CSS_SCALEY = 7;
    public static final int CSS_SKEW = 8;
    public static final int CSS_SKEWX = 9;
    public static final int CSS_SKEWY = 10;
    public static final int CSS_MATRIX = 11;
    public static final ArrayEx<String> transformNames = new ArrayEx<String>("translate", "translateX", "translateY", "rotate", "rotateX", "rotateY", "scale", "scaleX", "scaleY", "skew", "skewX", "skewY", "matrix");
    private final String operationType;

    public CSSTransformValue(String operationType) {
        this.operationType = operationType;
    }

    @Override
    public String cssText() {
        return this.operationType + "(" + super.cssText() + ")";
    }

    public static int determineType(String type) {
        if (type.indexOf("translate") == 0) {
            if (type.length() == 10) {
                if (type.charAt(9) == 'X') {
                    return 2;
                }
                return 3;
            }
            return 1;
        }
        if (type.indexOf("rotate") == 0) {
            return 4;
        }
        if (type.indexOf("scale") == 0) {
            if (type.length() == 6) {
                if (type.charAt(5) == 'X') {
                    return 6;
                }
                return 7;
            }
            return 5;
        }
        if (type.indexOf("skew") == 0) {
            if (type.length() == 5) {
                if (type.charAt(4) == 'X') {
                    return 9;
                }
                return 10;
            }
            return 8;
        }
        if (type.indexOf("matrix") == 0) {
            return 11;
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.operationType;
    }
}

