/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geo.ConicProjection;
import com.ibm.vida.rave.core.geo.InvertibleProjection;
import com.ibm.vida.rave.core.geo.Projection;
import com.ibm.vida.rave.core.geo.StreamListener;
import com.ibm.vida.rave.core.geo.TransformStreamListener;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.geo.ConicProjectionFactoryImpl;
import com.ibm.vida.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.vida.rave.core.internal.geo.TransformStreamListenerImpl;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class AlbersUsaProjection
implements InvertibleProjection {
    private ArrayEx<Double> point;
    private final ConicProjection lower48;
    private final ConicProjection alaska;
    private final ConicProjection hawaii;
    private final DelegatingStreamListener pointStream;
    private DelegatingStreamListener.StreamPointStateHandler lower48Point;
    private DelegatingStreamListener.StreamPointStateHandler alaskaPoint;
    private DelegatingStreamListener.StreamPointStateHandler hawaiiPoint;

    private AlbersUsaProjection() {
        final AlbersUsaProjection self = this;
        this.lower48 = AlbersUsaProjection.newAlbersProjection();
        ConicProjection cea = ConicProjectionFactoryImpl.newConicEqualAreaProjectionFactory().create();
        cea.rotate(new ArrayEx<Double>(154.0, 0.0)).center(new ArrayEx<Double>(-2.0, 58.5));
        cea.parallels(new ArrayEx<Double>(55.0, 65.0));
        this.alaska = cea;
        cea = ConicProjectionFactoryImpl.newConicEqualAreaProjectionFactory().create();
        cea.rotate(new ArrayEx<Double>(157.0, 0.0)).center(new ArrayEx<Double>(-3.0, 19.9));
        cea.parallels(new ArrayEx<Double>(8.0, 18.0));
        this.hawaii = cea;
        this.pointStream = new DelegatingStreamListener();
        this.pointStream.setPointDelegate(new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                self.point = new ArrayEx<Double>(x, y);
            }
        });
    }

    @Override
    public ArrayEx<Double> rotate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Projection rotate(ArrayEx<Double> rotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayEx<Double> center() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Projection center(ArrayEx<Double> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double clipAngle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Projection clipAngle(Object a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayEx<ArrayEx<Double>> clipExtent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Projection clipExtent(ArrayEx<ArrayEx<Double>> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayEx<Double> invert(ArrayEx<Double> coordinates) {
        double k = this.lower48.scale();
        ArrayEx<Double> t = this.lower48.translate();
        double x = ((Double)coordinates.get(0) - (Double)t.get(0)) / k;
        double y = ((Double)coordinates.get(1) - (Double)t.get(1)) / k;
        return (y >= 0.12 && y < 0.234 && x >= -0.425 && x < -0.214 ? this.alaska : (y >= 0.166 && y < 0.234 && x >= -0.214 && x < -0.115 ? this.hawaii : this.lower48)).invert(coordinates);
    }

    @Override
    public ArrayEx<Double> project(ArrayEx<Double> coordinates) {
        double x = (Double)coordinates.get(0);
        double y = (Double)coordinates.get(1);
        this.point = null;
        this.lower48Point.handle(x, y, Double.NaN);
        if (this.point != null) {
            return this.point;
        }
        this.alaskaPoint.handle(x, y, Double.NaN);
        if (this.point != null) {
            return this.point;
        }
        this.hawaiiPoint.handle(x, y, Double.NaN);
        return this.point;
    }

    @Override
    public ArrayEx<Double> translate() {
        return this.lower48.translate();
    }

    @Override
    public Projection translate(ArrayEx<? extends Object> t) {
        double k = this.lower48.scale();
        double x = ObjectConverter.toDouble(t.get(0));
        double y = ObjectConverter.toDouble(t.get(1));
        this.lower48Point = this.lower48.translate(t).clipExtent(new ArrayEx<ArrayEx<Double>>(new ArrayEx<Double>(x - 0.455 * k, y - 0.238 * k), new ArrayEx<Double>(x + 0.455 * k, y + 0.238 * k))).stream(this.pointStream).getPointDelegate();
        this.alaskaPoint = this.alaska.translate(new ArrayEx<Double>(x - 0.307 * k, y + 0.201 * k)).clipExtent(new ArrayEx<ArrayEx<Double>>(new ArrayEx<Double>(x - 0.425 * k + 1.0E-6, y + 0.12 * k + 1.0E-6), new ArrayEx<Double>(x - 0.214 * k - 1.0E-6, y + 0.234 * k - 1.0E-6))).stream(this.pointStream).getPointDelegate();
        this.hawaiiPoint = this.hawaii.translate(new ArrayEx<Double>(x - 0.205 * k, y + 0.212 * k)).clipExtent(new ArrayEx<ArrayEx<Double>>(new ArrayEx<Double>(x - 0.214 * k + 1.0E-6, y + 0.166 * k + 1.0E-6), new ArrayEx<Double>(x - 0.115 * k - 1.0E-6, y + 0.234 * k - 1.0E-6))).stream(this.pointStream).getPointDelegate();
        return this;
    }

    @Override
    public Double scale() {
        return this.lower48.scale();
    }

    @Override
    public Projection scale(Object s) {
        this.lower48.scale(s);
        this.alaska.scale(ObjectConverter.toDouble(s) * 0.35);
        this.hawaii.scale(s);
        return this.translate(this.lower48.translate());
    }

    @Override
    public Double precision() {
        return this.lower48.precision();
    }

    @Override
    public Projection precision(Double p) {
        this.lower48.precision(p);
        this.alaska.precision(p);
        this.hawaii.precision(p);
        return this;
    }

    @Override
    public TransformStreamListener stream(StreamListener listener) {
        final TransformStreamListener lower48Stream = this.lower48.stream(listener);
        final TransformStreamListener alaskaStream = this.alaska.stream(listener);
        final TransformStreamListener hawaiiStream = this.hawaii.stream(listener);
        OMap<String, DelegatingStreamListener.BaseStreamStateHandler> delegates = new OMap<String, DelegatingStreamListener.BaseStreamStateHandler>();
        delegates.put("point", new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                lower48Stream.point(x, y, z);
                alaskaStream.point(x, y, z);
                hawaiiStream.point(x, y, z);
            }
        });
        delegates.put("sphere", new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                lower48Stream.sphere();
                alaskaStream.sphere();
                hawaiiStream.sphere();
            }
        });
        delegates.put("lineStart", new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                lower48Stream.lineStart();
                alaskaStream.lineStart();
                hawaiiStream.lineStart();
            }
        });
        delegates.put("lineEnd", new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                lower48Stream.lineEnd();
                alaskaStream.lineEnd();
                hawaiiStream.lineEnd();
            }
        });
        delegates.put("polygonStart", new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                lower48Stream.polygonStart();
                alaskaStream.polygonStart();
                hawaiiStream.polygonStart();
            }
        });
        delegates.put("polygonEnd", new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                lower48Stream.polygonEnd();
                alaskaStream.polygonEnd();
                hawaiiStream.polygonEnd();
            }
        });
        return new TransformStreamListenerImpl(listener, delegates);
    }

    public static AlbersUsaProjection newAlbersUsaProjection() {
        AlbersUsaProjection a = new AlbersUsaProjection();
        a.scale(1070);
        return a;
    }

    public static ConicProjection newAlbersProjection() {
        ConicProjection cea = ConicProjectionFactoryImpl.newConicEqualAreaProjectionFactory().create();
        cea.rotate(new ArrayEx<Double>(96.0, 0.0)).center(new ArrayEx<Double>(-0.6, 38.7));
        cea.parallels(new ArrayEx<Double>(29.5, 45.5)).scale(1070);
        return cea;
    }

    @Override
    public final boolean supportInversion() {
        return true;
    }

    @Override
    public final boolean supportStreaming() {
        return true;
    }
}

