/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.vida.rave.core.geo.InvertiblePointProjector;
import com.ibm.vida.rave.core.geo.PointProjector;
import com.ibm.vida.rave.core.geo.PointProjectorFactory;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class AzimuthalPointProjectorFactory
implements PointProjectorFactory {
    static final AzimuthalPointProjectorFactory INSTANCE = new AzimuthalPointProjectorFactory();

    private AzimuthalPointProjectorFactory() {
    }

    @Override
    public PointProjector create(Object ... args) {
        final ValueFunction scale = (ValueFunction)args[0];
        final ValueFunction angle = (ValueFunction)args[1];
        return new InvertiblePointProjector(){

            @Override
            public boolean supportInversion() {
                return true;
            }

            @Override
            public double[] project(double \u03bb, double \u03c6) {
                double cos\u03bb = Math.cos(\u03bb);
                double cos\u03c6 = Math.cos(\u03c6);
                double k = scale.getValue(cos\u03bb * cos\u03c6);
                return new double[]{k * cos\u03c6 * Math.sin(\u03bb), k * Math.sin(\u03c6)};
            }

            @Override
            public double[] invert(double x, double y) {
                double \u03c1 = Math.sqrt(x * x + y * y);
                double c = angle.getValue(\u03c1);
                double sinc = Math.sin(c);
                double cosc = Math.cos(c);
                return new double[]{Math.atan2(x * sinc, \u03c1 * cosc), Math.asin(ObjectConverter.toBoolean(\u03c1) ? y * sinc / \u03c1 : \u03c1)};
            }
        };
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface ValueFunction {
        public double getValue(double var1);
    }
}

