/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

public final class CartesianUtil {
    private CartesianUtil() {
    }

    public static double[] cartesian(double[] spherical) {
        double \u03bb = spherical[0];
        double \u03c6 = spherical[1];
        double cos\u03c6 = Math.cos(\u03c6);
        return new double[]{cos\u03c6 * Math.cos(\u03bb), cos\u03c6 * Math.sin(\u03bb), Math.sin(\u03c6)};
    }

    public static double cartesianDot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static double[] cartesianCross(double[] a, double[] b) {
        double x = a[1] * b[2] - a[2] * b[1];
        double y = a[2] * b[0] - a[0] * b[2];
        double z = a[0] * b[1] - a[1] * b[0];
        return new double[]{x, y, z};
    }

    public static void cartesianAdd(double[] a, double[] b) {
        a[0] = a[0] + b[0];
        a[1] = a[1] + b[1];
        a[2] = a[2] + b[2];
    }

    public static double[] cartesianScale(double[] vector, double k) {
        return new double[]{vector[0] * k, vector[1] * k, vector[2] * k};
    }

    public static void cartesianNormalize(double[] d) {
        double l = Math.sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
        d[0] = d[0] / l;
        d[1] = d[1] / l;
        d[2] = d[2] / l;
    }
}

