/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geo.StreamListener;
import com.ibm.vida.rave.core.internal.geo.CartesianUtil;
import com.ibm.vida.rave.core.internal.geo.ClipLineStreamListenerFactory;
import com.ibm.vida.rave.core.internal.geo.ClipUtil;
import com.ibm.vida.rave.core.internal.geo.SphericalUtil;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

final class CircleClipLineStreamListenerFactory
implements ClipLineStreamListenerFactory {
    private double radius;
    private ClipUtil.PointVisiblity visible;
    private double cr;
    private boolean smallRadius;
    private boolean notHemisphere;
    private ArrayEx<Double> point0;
    private int c0;
    private boolean v0;
    private boolean v00;
    private int clean;

    CircleClipLineStreamListenerFactory(double radius) {
        final CircleClipLineStreamListenerFactory self = this;
        this.radius = radius;
        this.cr = Math.cos(radius);
        this.smallRadius = this.cr > 0.0;
        this.notHemisphere = Math.abs(this.cr) > 1.0E-6;
        this.visible = new ClipUtil.PointVisiblity(){

            @Override
            public boolean isPointVisible(double \u03bb, double \u03c6, double z) {
                return Math.cos(\u03bb) * Math.cos(\u03c6) > self.cr;
            }
        };
    }

    ClipUtil.PointVisiblity getPointVisiblilty() {
        return this.visible;
    }

    boolean isSmallRadius() {
        return this.smallRadius;
    }

    @Override
    public ClipLineStreamListenerFactory.ClipLineStreamListener stream(final StreamListener listener) {
        final CircleClipLineStreamListenerFactory self = this;
        return new ClipLineStreamListenerFactory.ClipLineStreamListener(){

            @Override
            public void sphere() {
            }

            @Override
            public void point(double \u03bb, double \u03c6, double z) {
                ArrayEx t;
                ArrayEx point2;
                int c;
                ArrayEx<Double> point1 = new ArrayEx<Double>(\u03bb, \u03c6);
                boolean v = self.visible.isPointVisible(\u03bb, \u03c6, Double.NaN);
                int n = self.smallRadius ? (v ? 0 : self.code(\u03bb, \u03c6)) : (v ? self.code(\u03bb + (\u03bb < 0.0 ? Math.PI : -Math.PI), \u03c6) : (c = 0));
                if (self.point0 == null && (self.v00 = (self.v0 = v))) {
                    listener.lineStart();
                }
                if (v != self.v0) {
                    point2 = self.intersect(self.point0, point1, false);
                    if (SphericalUtil.sphericalEqual(Lang.asPrimitiveDouble(self.point0), Lang.asPrimitiveDouble(point2)) || SphericalUtil.sphericalEqual(Lang.asPrimitiveDouble(point1), Lang.asPrimitiveDouble(point2))) {
                        point1.set(0, (Double)point1.get(0) + 1.0E-6);
                        point1.set(1, (Double)point1.get(1) + 1.0E-6);
                        v = self.visible.isPointVisible((Double)point1.get(0), (Double)point1.get(1), Double.NaN);
                    }
                }
                if (v != self.v0) {
                    self.clean = 0;
                    if (v) {
                        listener.lineStart();
                        point2 = self.intersect(point1, self.point0, false);
                        listener.point((Double)point2.get(0), (Double)point2.get(1), Double.NaN);
                    } else {
                        point2 = self.intersect(self.point0, point1, false);
                        listener.point((Double)point2.get(0), (Double)point2.get(1), Double.NaN);
                        listener.lineEnd();
                    }
                    self.point0 = point2;
                } else if (self.notHemisphere && self.point0 != null && self.smallRadius ^ v && (c & self.c0) == 0 && (t = self.intersect(point1, self.point0, true)) != null) {
                    self.clean = 0;
                    if (self.smallRadius) {
                        listener.lineStart();
                        listener.point((Double)((ArrayEx)t.get(0)).get(0), (Double)((ArrayEx)t.get(0)).get(1), Double.NaN);
                        listener.point((Double)((ArrayEx)t.get(1)).get(0), (Double)((ArrayEx)t.get(1)).get(1), Double.NaN);
                        listener.lineEnd();
                    } else {
                        listener.point((Double)((ArrayEx)t.get(1)).get(0), (Double)((ArrayEx)t.get(1)).get(1), Double.NaN);
                        listener.lineEnd();
                        listener.lineStart();
                        listener.point((Double)((ArrayEx)t.get(0)).get(0), (Double)((ArrayEx)t.get(0)).get(1), Double.NaN);
                    }
                }
                if (v && (self.point0 == null || !SphericalUtil.sphericalEqual(Lang.asPrimitiveDouble(self.point0), Lang.asPrimitiveDouble(point1)))) {
                    listener.point((Double)point1.get(0), (Double)point1.get(1), Double.NaN);
                }
                self.point0 = point1;
                self.v0 = v;
                self.c0 = c;
            }

            @Override
            public void lineStart() {
                self.v00 = (self.v0 = false);
                self.clean = 1;
            }

            @Override
            public void lineEnd() {
                if (self.v0) {
                    listener.lineEnd();
                }
                self.point0 = null;
            }

            @Override
            public void polygonStart() {
            }

            @Override
            public void polygonEnd() {
            }

            @Override
            public int clean() {
                return self.clean | (self.v00 && self.v0 ? 2 : 0);
            }
        };
    }

    private ArrayEx intersect(ArrayEx<Double> a, ArrayEx<Double> b, boolean two) {
        boolean meridian;
        double \u03b4\u03bb;
        double z;
        double n1n2;
        double[] pa = CartesianUtil.cartesian(Lang.asPrimitiveDouble(a));
        double[] pb = CartesianUtil.cartesian(Lang.asPrimitiveDouble(b));
        double[] n1 = new double[]{1.0, 0.0, 0.0};
        double[] n2 = CartesianUtil.cartesianCross(pa, pb);
        double n2n2 = CartesianUtil.cartesianDot(n2, n2);
        double determinant = n2n2 - (n1n2 = n2[0]) * n1n2;
        if (!ObjectConverter.toBoolean(determinant)) {
            if (!two) {
                return a;
            }
            return null;
        }
        double c1 = this.cr * n2n2 / determinant;
        double c2 = -this.cr * n1n2 / determinant;
        double[] n1xn2 = CartesianUtil.cartesianCross(n1, n2);
        double[] A = CartesianUtil.cartesianScale(n1, c1);
        double[] B = CartesianUtil.cartesianScale(n2, c2);
        CartesianUtil.cartesianAdd(A, B);
        double[] u = n1xn2;
        double w = CartesianUtil.cartesianDot(A, u);
        double uu = CartesianUtil.cartesianDot(u, u);
        double t2 = w * w - uu * (CartesianUtil.cartesianDot(A, A) - 1.0);
        if (t2 < 0.0) {
            return null;
        }
        double t = Math.sqrt(t2);
        double[] q = CartesianUtil.cartesianScale(u, (-w - t) / uu);
        CartesianUtil.cartesianAdd(q, A);
        q = SphericalUtil.spherical(q);
        if (!two) {
            return Lang.toArray(Lang.asDouble(q));
        }
        double \u03bb0 = (Double)a.get(0);
        double \u03bb1 = (Double)b.get(0);
        double \u03c60 = (Double)a.get(1);
        double \u03c61 = (Double)b.get(1);
        if (\u03bb1 < \u03bb0) {
            z = \u03bb0;
            \u03bb0 = \u03bb1;
            \u03bb1 = z;
        }
        boolean polar = Math.abs((\u03b4\u03bb = \u03bb1 - \u03bb0) - Math.PI) < 1.0E-6;
        boolean bl = meridian = polar || \u03b4\u03bb < 1.0E-6;
        if (!polar && \u03c61 < \u03c60) {
            z = \u03c60;
            \u03c60 = \u03c61;
            \u03c61 = z;
        }
        boolean pointIsBetween = false;
        pointIsBetween = meridian ? (polar ? \u03c60 + \u03c61 > 0.0 ^ q[1] < (Math.abs(q[0] - \u03bb0) < 1.0E-6 ? \u03c60 : \u03c61) : \u03c60 <= q[1] && q[1] <= \u03c61) : \u03b4\u03bb > Math.PI ^ (\u03bb0 <= q[0] && q[0] <= \u03bb1);
        if (pointIsBetween) {
            double[] q1 = CartesianUtil.cartesianScale(u, (-w + t) / uu);
            CartesianUtil.cartesianAdd(q1, A);
            return new ArrayEx<ArrayEx>(Lang.toArray(Lang.asDouble(q)), Lang.toArray(Lang.asDouble(SphericalUtil.spherical(q1))));
        }
        return null;
    }

    private int code(double \u03bb, double \u03c6) {
        double r = this.smallRadius ? this.radius : Math.PI - this.radius;
        int code = 0;
        if (\u03bb < -r) {
            code |= 1;
        } else if (\u03bb > r) {
            code |= 2;
        }
        if (\u03c6 < -r) {
            code |= 4;
        } else if (\u03c6 > r) {
            code |= 8;
        }
        return code;
    }
}

