/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.vida.rave.core.arrays.Merge;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geo.StreamListener;
import com.ibm.vida.rave.core.geo.TransformStreamListener;
import com.ibm.vida.rave.core.geom.ClipLine;
import com.ibm.vida.rave.core.geom.Line;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.internal.geo.ClipBufferStreamListener;
import com.ibm.vida.rave.core.internal.geo.ClipPolygonIntersection;
import com.ibm.vida.rave.core.internal.geo.ClipUtil;
import com.ibm.vida.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.vida.rave.core.internal.geo.GeoInterpolator;
import com.ibm.vida.rave.core.internal.math.Trigonometry;
import com.ibm.vida.rave.core.util.Comparator;

public final class ClipExtentStreamListener
extends TransformStreamListener {
    private static final double clipExtentMAX = 1.0E9;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double x__;
    private double y__;
    private double x_;
    private double y_;
    private boolean first;
    private boolean clean;
    private boolean v__;
    private boolean v_;
    private StreamListener listener;
    private final StreamListener clientListener;
    private final ClipBufferStreamListener bufferListener;
    private final ClipLine.LineClipper lineClipper;
    private final Comparator<ClipPolygonIntersection> comparator;
    private final GeoInterpolator interpolator;
    private ArrayEx<ArrayEx<ArrayEx<ArrayEx<Double>>>> segments;
    private ArrayEx<ArrayEx<ArrayEx<Double>>> polygon;
    private ArrayEx<ArrayEx<Double>> ring;

    ClipExtentStreamListener(double x0, double y0, double x1, double y1, StreamListener clientListener) {
        final ClipExtentStreamListener self = this;
        this.clientListener = clientListener;
        this.listener = clientListener;
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.lineClipper = ClipLine.create(x0, y0, x1, y1);
        this.bufferListener = new ClipBufferStreamListener();
        this.comparator = new Comparator<ClipPolygonIntersection>(){

            @Override
            public int compare(ClipPolygonIntersection a, ClipPolygonIntersection b) {
                double result = self.comparePoints(a.getPoint(), b.getPoint());
                return result == 0.0 ? 0 : (result > 0.0 ? 1 : -1);
            }
        };
        this.interpolator = new GeoInterpolator(){

            @Override
            public void interpolate(ArrayEx<Double> from, ArrayEx<Double> to, int direction, StreamListener listener) {
                double a = 0.0;
                double a1 = 0.0;
                if (from == null || (a = (double)self.corner(from, direction)) != (a1 = (double)self.corner(to, direction)) || self.comparePoints(from, to) < 0.0 ^ direction > 0) {
                    do {
                        listener.point(a == 0.0 || a == 3.0 ? self.x0 : self.x1, a > 1.0 ? self.y1 : self.y0, Double.NaN);
                    } while ((a = (a + (double)direction + 4.0) % 4.0) != a1);
                } else {
                    listener.point((Double)to.get(0), (Double)to.get(1), Double.NaN);
                }
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                if (self.pointVisible(x, y)) {
                    self.listener.point(x, y, Double.NaN);
                }
            }
        };
        final DelegatingStreamListener.StreamPointStateHandler linePoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                double _x = x;
                double _y = y;
                _x = Math.max(-1.0E9, Math.min(1.0E9, _x));
                _y = Math.max(-1.0E9, Math.min(1.0E9, _y));
                boolean v = self.pointVisible(_x, _y);
                if (self.polygon != null) {
                    self.ring.push(new ArrayEx<Object>(_x, _y));
                }
                if (self.first) {
                    self.x__ = _x;
                    self.y__ = _y;
                    self.v__ = v;
                    self.first = false;
                    if (v) {
                        self.listener.lineStart();
                        self.listener.point(_x, _y, Double.NaN);
                    }
                } else if (v && self.v_) {
                    self.listener.point(_x, _y, Double.NaN);
                } else {
                    Line l = new Line(new PointStruct(self.x_, self.y_), new PointStruct(_x, _y));
                    if (self.lineClipper.clip(l) != null) {
                        if (!self.v_) {
                            self.listener.lineStart();
                            self.listener.point(l.getA().x, l.getA().y, Double.NaN);
                        }
                        self.listener.point(l.getB().x, l.getB().y, Double.NaN);
                        if (!v) {
                            self.listener.lineEnd();
                        }
                        self.clean = false;
                    } else if (v) {
                        self.listener.lineStart();
                        self.listener.point(_x, _y, Double.NaN);
                        self.clean = false;
                    }
                }
                self.x_ = _x;
                self.y_ = _y;
                self.v_ = v;
            }
        };
        DelegatingStreamListener.StreamStateHandler lineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.setPointDelegate(linePoint);
                if (self.polygon != null) {
                    self.polygon.push(self.ring = new ArrayEx());
                }
                self.first = true;
                self.v_ = false;
                self.x_ = (self.y_ = Double.NaN);
            }
        };
        DelegatingStreamListener.StreamStateHandler lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                if (self.segments != null) {
                    linePoint.handle(self.x__, self.y__, Double.NaN);
                    if (self.v__ && self.v_) {
                        self.bufferListener.rejoin();
                    }
                    self.segments.push(self.bufferListener.buffer());
                }
                self.setPointDelegate(point);
                if (self.v_) {
                    self.listener.lineEnd();
                }
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.listener = self.bufferListener;
                self.segments = new ArrayEx();
                self.polygon = new ArrayEx();
                self.clean = true;
            }
        };
        DelegatingStreamListener.StreamStateHandler polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                boolean visible;
                self.listener = self.clientListener;
                ArrayEx mergedSegments = (ArrayEx)Merge.merge(self.segments);
                boolean clipStartInside = self.insidePolygon(new ArrayEx<Double>(self.x0, self.y1));
                boolean inside = self.clean && clipStartInside;
                boolean bl = visible = mergedSegments.length() > 0;
                if (inside || visible) {
                    self.listener.polygonStart();
                    if (inside) {
                        self.listener.lineStart();
                        self.interpolator.interpolate(null, null, 1, self.listener);
                        self.listener.lineEnd();
                    }
                    if (visible) {
                        ClipUtil.clipPolygon(mergedSegments, self.comparator, clipStartInside, self.interpolator, self.listener);
                    }
                    self.listener.polygonEnd();
                }
                self.segments = null;
                self.polygon = null;
                self.ring = null;
            }
        };
        this.setPointDelegate(point);
        this.setLineStartDelegate(lineStart);
        this.setLineEndDelegate(lineEnd);
        this.setPolygonStartDelegate(polygonStart);
        this.setPolygonEndDelegate(polygonEnd);
    }

    private int corner(ArrayEx<Double> p, int direction) {
        return Math.abs((Double)p.get(0) - this.x0) < 1.0E-6 ? (direction > 0 ? 0 : 3) : (Math.abs((Double)p.get(0) - this.x1) < 1.0E-6 ? (direction > 0 ? 2 : 1) : (Math.abs((Double)p.get(1) - this.y0) < 1.0E-6 ? (direction > 0 ? 1 : 0) : (direction > 0 ? 3 : 2)));
    }

    private double comparePoints(ArrayEx<Double> a, ArrayEx<Double> b) {
        int cb;
        int ca = this.corner(a, 1);
        double result = ca != (cb = this.corner(b, 1)) ? (double)(ca - cb) : (ca == 0 ? (Double)b.get(1) - (Double)a.get(1) : (ca == 1 ? (Double)a.get(0) - (Double)b.get(0) : (ca == 2 ? (Double)a.get(1) - (Double)b.get(1) : (Double)b.get(0) - (Double)a.get(0))));
        return result;
    }

    private boolean pointVisible(double x, double y) {
        return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
    }

    private boolean insidePolygon(ArrayEx<Double> p) {
        int wn = 0;
        int n = this.polygon.length();
        double y = (Double)p.get(1);
        for (int i = 0; i < n; ++i) {
            ArrayEx v = (ArrayEx)this.polygon.get(i);
            ArrayEx a = (ArrayEx)v.get(0);
            int m = v.length();
            for (int j = 1; j < m; ++j) {
                ArrayEx b = (ArrayEx)v.get(j);
                if ((Double)a.get(1) <= y) {
                    if ((Double)b.get(1) > y && Trigonometry.cross2d(a, b, p) > 0.0) {
                        ++wn;
                    }
                } else if ((Double)b.get(1) <= y && Trigonometry.cross2d(a, b, p) < 0.0) {
                    --wn;
                }
                a = b;
            }
        }
        return wn != 0;
    }

    @Override
    public StreamListener getStreamListener() {
        return this.clientListener;
    }
}

