/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.vida.rave.core.geo.InvertiblePointProjector;
import com.ibm.vida.rave.core.geo.InvertibleProjection;
import com.ibm.vida.rave.core.geo.PlaneProjectionFactory;
import com.ibm.vida.rave.core.geo.PointProjector;
import com.ibm.vida.rave.core.internal.geo.AzimuthalPointProjectorFactory;
import com.ibm.vida.rave.core.internal.geo.InvertibleProjectionImpl;
import com.ibm.vida.rave.core.internal.geo.ProjectionMutatorImpl;
import com.ibm.vida.rave.core.internal.math.Trigonometry;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class PlaneProjectionFactoryImpl
implements PlaneProjectionFactory {
    private final PointProjector raw;

    private PlaneProjectionFactoryImpl(PointProjector projector) {
        this.raw = projector;
    }

    @Override
    public final InvertibleProjection create() {
        InvertibleProjectionImpl projection = new InvertibleProjectionImpl();
        ProjectionMutatorImpl.internalMutate(projection, this.raw);
        return projection;
    }

    @Override
    public final PointProjector getRaw() {
        return this.raw;
    }

    public static PlaneProjectionFactory newAzimuthalEqualAreaProjectionFactory() {
        InvertiblePointProjector projector = (InvertiblePointProjector)AzimuthalPointProjectorFactory.INSTANCE.create(new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return Math.sqrt(2.0 / (1.0 + x));
            }
        }, new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return 2.0 * Math.asin(x / 2.0);
            }
        });
        return new PlaneProjectionFactoryImpl(projector);
    }

    public static PlaneProjectionFactory newAzimuthalEquidistantProjectionFactory() {
        InvertiblePointProjector projector = (InvertiblePointProjector)AzimuthalPointProjectorFactory.INSTANCE.create(new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                double c = Math.acos(x);
                return ObjectConverter.toBoolean(c) ? c / Math.sin(c) : c;
            }
        }, new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return x;
            }
        });
        return new PlaneProjectionFactoryImpl(projector);
    }

    public static PlaneProjectionFactory newEquirectangularProjectionFactory() {
        InvertiblePointProjector projector = new InvertiblePointProjector(){

            @Override
            public boolean supportInversion() {
                return true;
            }

            @Override
            public double[] invert(double x, double y) {
                return new double[]{x, y};
            }

            @Override
            public double[] project(double \u03bb, double \u03c6) {
                return new double[]{\u03bb, \u03c6};
            }
        };
        return new PlaneProjectionFactoryImpl(projector);
    }

    public static PlaneProjectionFactory newGnomonicProjectionFactory() {
        InvertiblePointProjector projector = (InvertiblePointProjector)AzimuthalPointProjectorFactory.INSTANCE.create(new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return 1.0 / x;
            }
        }, new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return Math.atan(x);
            }
        });
        return new PlaneProjectionFactoryImpl(projector);
    }

    public static PlaneProjectionFactory newOrthographicProjectionFactory() {
        InvertiblePointProjector projector = (InvertiblePointProjector)AzimuthalPointProjectorFactory.INSTANCE.create(new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return 1.0;
            }
        }, new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return Math.asin(x);
            }
        });
        return new PlaneProjectionFactoryImpl(projector);
    }

    public static PlaneProjectionFactory newStereographicProjectionFactory() {
        InvertiblePointProjector projector = (InvertiblePointProjector)AzimuthalPointProjectorFactory.INSTANCE.create(new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return 1.0 / (1.0 + x);
            }
        }, new AzimuthalPointProjectorFactory.ValueFunction(){

            @Override
            public double getValue(double x) {
                return 2.0 * Math.atan(x);
            }
        });
        return new PlaneProjectionFactoryImpl(projector);
    }

    public static PlaneProjectionFactory newWinkelTripelProjectionFactory() {
        InvertiblePointProjector projector = new InvertiblePointProjector(){

            @Override
            public boolean supportInversion() {
                return true;
            }

            @Override
            public double[] invert(double x, double y) {
                double \u03b4\u03c6;
                double \u03b4\u03bb;
                int i = 25;
                double \u03bb = x;
                double \u03c6 = y;
                do {
                    double d;
                    double F;
                    \u03b4\u03c6 = 0.0;
                    \u03b4\u03bb = 0.0;
                    double cos\u03c6 = Math.cos(\u03c6);
                    double sin\u03c6 = Math.sin(\u03c6);
                    double sin_2\u03c6 = Math.sin(2.0 * \u03c6);
                    double sin2\u03c6 = sin\u03c6 * sin\u03c6;
                    double cos2\u03c6 = cos\u03c6 * cos\u03c6;
                    double sin\u03bb = Math.sin(\u03bb);
                    double cos\u03bb_2 = Math.cos(\u03bb / 2.0);
                    double sin\u03bb_2 = Math.sin(\u03bb / 2.0);
                    double sin2\u03bb_2 = sin\u03bb_2 * sin\u03bb_2;
                    double C = 1.0 - cos2\u03c6 * cos\u03bb_2 * cos\u03bb_2;
                    if (C != 0.0) {
                        F = 1.0 / C;
                        d = Trigonometry.acos(cos\u03c6 * cos\u03bb_2) * Math.sqrt(F);
                    } else {
                        d = F = 0.0;
                    }
                    double E = d;
                    double fx = 0.5 * (2.0 * E * cos\u03c6 * sin\u03bb_2 + \u03bb / 1.5707963267948966) - x;
                    double fy = 0.5 * (E * sin\u03c6 + \u03c6) - y;
                    double \u03b4x\u03b4\u03bb = 0.5 * F * (cos2\u03c6 * sin2\u03bb_2 + E * cos\u03c6 * cos\u03bb_2 * sin2\u03c6) + 0.3183098861837907;
                    double \u03b4x\u03b4\u03c6 = F * (sin\u03bb * sin_2\u03c6 / 4.0 - E * sin\u03c6 * sin\u03bb_2);
                    double \u03b4y\u03b4\u03bb = 0.125 * F * (sin_2\u03c6 * sin\u03bb_2 - E * sin\u03c6 * cos2\u03c6 * sin\u03bb);
                    double \u03b4y\u03b4\u03c6 = 0.5 * F * (sin2\u03c6 * cos\u03bb_2 + E * sin2\u03bb_2 * cos\u03c6) + 0.5;
                    double denominator = \u03b4x\u03b4\u03c6 * \u03b4y\u03b4\u03bb - \u03b4y\u03b4\u03c6 * \u03b4x\u03b4\u03bb;
                    \u03b4\u03bb = (fy * \u03b4x\u03b4\u03c6 - fx * \u03b4y\u03b4\u03c6) / denominator;
                    \u03b4\u03c6 = (fx * \u03b4y\u03b4\u03bb - fy * \u03b4x\u03b4\u03bb) / denominator;
                    \u03bb -= \u03b4\u03bb;
                    \u03c6 -= \u03b4\u03c6;
                } while ((Math.abs(\u03b4\u03bb) > 1.0E-6 || Math.abs(\u03b4\u03c6) > 1.0E-6) && --i > 0);
                return new double[]{\u03bb, \u03c6};
            }

            @Override
            public double[] project(double \u03bb, double \u03c6) {
                double \u03bb2 = \u03bb / 2.0;
                double cos\u03c6 = Math.cos(\u03c6);
                double sincia = Trigonometry.sinci(Trigonometry.acos(cos\u03c6 * Math.cos(\u03bb2)));
                double a = 2.0 * cos\u03c6 * Math.sin(\u03bb2) * sincia;
                double b = Math.sin(\u03c6) * sincia;
                return new double[]{(a + \u03bb / 1.5707963267948966) / 2.0, (b + \u03c6) / 2.0};
            }
        };
        return new PlaneProjectionFactoryImpl(projector);
    }
}

