/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.geo.StreamListener;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.vida.rave.core.internal.geo.ResamplePointProjector;
import com.ibm.vida.rave.core.internal.geo.ResampleStreamListener;
import com.ibm.vida.rave.core.internal.geo.TransformStreamListenerImpl;

@FunctionClass(value="resample")
final class ResampleStreamListenerFactory {
    private final double cosMinDistance;
    private double \u03b42 = 0.5;
    private int maxDepth;
    private final ResamplePointProjector pointProjector;

    ResampleStreamListenerFactory(ResamplePointProjector projector) {
        this.pointProjector = projector;
        this.maxDepth = 16;
        this.cosMinDistance = Math.cos(0.5235987755982988);
    }

    public StreamListener resample(final StreamListener listener) {
        final ResampleStreamListenerFactory self = this;
        if (this.maxDepth == 0) {
            OMap<String, DelegatingStreamListener.BaseStreamStateHandler> delegates = new OMap<String, DelegatingStreamListener.BaseStreamStateHandler>();
            delegates.put("point", new DelegatingStreamListener.StreamPointStateHandler(){

                @Override
                public void handle(double x, double y, double z) {
                    double[] res = self.pointProjector.project(x, y, z);
                    listener.point(res[0], res[1], Double.NaN);
                }
            });
            return new TransformStreamListenerImpl(listener, delegates);
        }
        return new ResampleStreamListener(this, listener);
    }

    public ResampleStreamListenerFactory precision(double p) {
        this.\u03b42 = p * p;
        this.maxDepth = this.\u03b42 > 0.0 ? 16 : 0;
        return this;
    }

    public double precision() {
        return Math.sqrt(this.\u03b42);
    }

    final double getCosMinDistance() {
        return this.cosMinDistance;
    }

    final double getPrecisionSquared() {
        return this.\u03b42;
    }

    final int getMaxDepth() {
        return this.maxDepth;
    }

    final ResamplePointProjector getPointProjector() {
        return this.pointProjector;
    }
}

