/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.geo.Geo;
import com.ibm.vida.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.vida.rave.core.internal.math.Trigonometry;

public final class SphericalCentroid {
    private static final double[] NULL_CENTROID = new double[]{Double.NaN, Double.NaN};
    private double centroidW0;
    private double centroidW1;
    private double centroidX0;
    private double centroidY0;
    private double centroidZ0;
    private double centroidX1;
    private double centroidY1;
    private double centroidZ1;
    private double centroidX2;
    private double centroidY2;
    private double centroidZ2;
    private double ringStart_\u03bb00;
    private double ringStart_\u03c600;
    private double ringStart_x0;
    private double ringStart_y0;
    private double ringStart_z0;
    private double lineStart_x0;
    private double lineStart_y0;
    private double lineStart_z0;
    private final DelegatingStreamListener centroidStreamListener = new DelegatingStreamListener();
    private final DelegatingStreamListener.StreamPointStateHandler centroidPoint;
    private final DelegatingStreamListener.StreamStateHandler centroidLineStart;
    private final DelegatingStreamListener.StreamPointStateHandler centroidLineStart_point;
    private final DelegatingStreamListener.StreamPointStateHandler centroidLineStart_nextPoint;
    private final DelegatingStreamListener.StreamStateHandler centroidLineEnd;
    private final DelegatingStreamListener.StreamStateHandler polygonStart;
    private final DelegatingStreamListener.StreamStateHandler polygonEnd;
    private final DelegatingStreamListener.StreamStateHandler centroidRingStart;
    private final DelegatingStreamListener.StreamPointStateHandler centroidRingStart_point;
    private final DelegatingStreamListener.StreamPointStateHandler centroidRingStart_nextPoint;
    private final DelegatingStreamListener.StreamStateHandler centroidRingStart_lineEnd;

    public SphericalCentroid() {
        final SphericalCentroid self = this;
        this.centroidPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double _\u03bb = \u03bb;
                double _\u03c6 = \u03c6;
                double cos\u03c6 = Math.cos(_\u03c6 *= Math.PI / 180);
                self.centroidPointXYZ(cos\u03c6 * Math.cos(_\u03bb *= Math.PI / 180), cos\u03c6 * Math.sin(_\u03bb), Math.sin(_\u03c6));
            }
        };
        this.centroidLineStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.lineStart_x0 = (self.lineStart_y0 = (self.lineStart_z0 = 0.0));
                self.centroidStreamListener.setPointDelegate(self.centroidLineStart_point);
            }
        };
        this.centroidLineStart_point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double _\u03bb = \u03bb;
                double _\u03c6 = \u03c6;
                double cos\u03c6 = Math.cos(_\u03c6 *= Math.PI / 180);
                self.lineStart_x0 = cos\u03c6 * Math.cos(_\u03bb *= Math.PI / 180);
                self.lineStart_y0 = cos\u03c6 * Math.sin(_\u03bb);
                self.lineStart_z0 = Math.sin(_\u03c6);
                self.centroidStreamListener.setPointDelegate(self.centroidLineStart_nextPoint);
                self.centroidPointXYZ(self.lineStart_x0, self.lineStart_y0, self.lineStart_z0);
            }
        };
        this.centroidLineStart_nextPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double zz) {
                double _\u03bb = \u03bb;
                double _\u03c6 = \u03c6;
                double cos\u03c6 = Math.cos(_\u03c6 *= Math.PI / 180);
                double x = cos\u03c6 * Math.cos(_\u03bb *= Math.PI / 180);
                double y = cos\u03c6 * Math.sin(_\u03bb);
                double z = Math.sin(_\u03c6);
                double temp = self.lineStart_y0 * z - self.lineStart_z0 * y;
                double d = temp * temp;
                temp = self.lineStart_z0 * x - self.lineStart_x0 * z;
                double d2 = d + temp * temp;
                temp = self.lineStart_x0 * y - self.lineStart_y0 * x;
                double w = Math.atan2(Math.sqrt(d2 + temp * temp), self.lineStart_x0 * x + self.lineStart_y0 * y + self.lineStart_z0 * z);
                self.centroidW1 = self.centroidW1 + w;
                self.centroidX1 = self.centroidX1 + w * (self.lineStart_x0 + (self.lineStart_x0 = x));
                self.centroidY1 = self.centroidY1 + w * (self.lineStart_y0 + (self.lineStart_y0 = y));
                self.centroidZ1 = self.centroidZ1 + w * (self.lineStart_z0 + (self.lineStart_z0 = z));
                self.centroidPointXYZ(self.lineStart_x0, self.lineStart_y0, self.lineStart_z0);
            }
        };
        this.centroidLineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.centroidStreamListener.setPointDelegate(self.centroidPoint);
            }
        };
        this.polygonStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.centroidStreamListener.setLineStartDelegate(self.centroidRingStart);
            }
        };
        this.polygonEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.centroidStreamListener.setLineStartDelegate(self.centroidLineStart);
            }
        };
        this.centroidRingStart = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.ringStart_\u03bb00 = (self.ringStart_\u03c600 = (self.ringStart_x0 = (self.ringStart_y0 = (self.ringStart_z0 = 0.0))));
                self.centroidStreamListener.setPointDelegate(self.centroidRingStart_point);
                self.centroidStreamListener.setLineEndDelegate(self.centroidRingStart_lineEnd);
            }
        };
        this.centroidRingStart_point = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double z) {
                double _\u03bb = \u03bb;
                double _\u03c6 = \u03c6;
                self.ringStart_\u03bb00 = _\u03bb;
                self.ringStart_\u03c600 = _\u03c6;
                self.centroidStreamListener.setPointDelegate(self.centroidRingStart_nextPoint);
                double cos\u03c6 = Math.cos(_\u03c6 *= Math.PI / 180);
                self.ringStart_x0 = cos\u03c6 * Math.cos(_\u03bb *= Math.PI / 180);
                self.ringStart_y0 = cos\u03c6 * Math.sin(_\u03bb);
                self.ringStart_z0 = Math.sin(_\u03c6);
                self.centroidPointXYZ(self.ringStart_x0, self.ringStart_y0, self.ringStart_z0);
            }
        };
        this.centroidRingStart_nextPoint = new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double \u03bb, double \u03c6, double zz) {
                double _\u03bb = \u03bb;
                double _\u03c6 = \u03c6;
                double cos\u03c6 = Math.cos(_\u03c6 *= Math.PI / 180);
                double x = cos\u03c6 * Math.cos(_\u03bb *= Math.PI / 180);
                double y = cos\u03c6 * Math.sin(_\u03bb);
                double z = Math.sin(_\u03c6);
                double cx = self.ringStart_y0 * z - self.ringStart_z0 * y;
                double cy = self.ringStart_z0 * x - self.ringStart_x0 * z;
                double cz = self.ringStart_x0 * y - self.ringStart_y0 * x;
                double m = Math.sqrt(cx * cx + cy * cy + cz * cz);
                double u = self.ringStart_x0 * x + self.ringStart_y0 * y + self.ringStart_z0 * z;
                double v = m == 0.0 || Double.isNaN(m) ? m : -Trigonometry.acos(u) / m;
                double w = Math.atan2(m, u);
                self.centroidX2 = self.centroidX2 + v * cx;
                self.centroidY2 = self.centroidY2 + v * cy;
                self.centroidZ2 = self.centroidZ2 + v * cz;
                self.centroidW1 = self.centroidW1 + w;
                self.centroidX1 = self.centroidX1 + w * (self.ringStart_x0 + (self.ringStart_x0 = x));
                self.centroidY1 = self.centroidY1 + w * (self.ringStart_y0 + (self.ringStart_y0 = y));
                self.centroidZ1 = self.centroidZ1 + w * (self.ringStart_z0 + (self.ringStart_z0 = z));
                self.centroidPointXYZ(self.ringStart_x0, self.ringStart_y0, self.ringStart_z0);
            }
        };
        this.centroidRingStart_lineEnd = new DelegatingStreamListener.StreamStateHandler(){

            @Override
            public void handle() {
                self.centroidRingStart_nextPoint.handle(self.ringStart_\u03bb00, self.ringStart_\u03c600, Double.NaN);
                self.centroidStreamListener.setLineEndDelegate(self.centroidLineEnd);
                self.centroidStreamListener.setPointDelegate(self.centroidPoint);
            }
        };
        this.centroidStreamListener.setPointDelegate(this.centroidPoint);
        this.centroidStreamListener.setLineStartDelegate(this.centroidLineStart);
        this.centroidStreamListener.setLineEndDelegate(this.centroidLineEnd);
        this.centroidStreamListener.setPolygonStartDelegate(this.polygonStart);
        this.centroidStreamListener.setPolygonEndDelegate(this.polygonEnd);
    }

    private void centroidPointXYZ(double x, double y, double z) {
        this.centroidW0 += 1.0;
        this.centroidX0 += (x - this.centroidX0) / this.centroidW0;
        this.centroidY0 += (y - this.centroidY0) / this.centroidW0;
        this.centroidZ0 += (z - this.centroidZ0) / this.centroidW0;
    }

    public double[] calculateCentroid(JSONObject feature) {
        this.centroidZ2 = 0.0;
        this.centroidY2 = 0.0;
        this.centroidX2 = 0.0;
        this.centroidZ1 = 0.0;
        this.centroidY1 = 0.0;
        this.centroidX1 = 0.0;
        this.centroidZ0 = 0.0;
        this.centroidY0 = 0.0;
        this.centroidX0 = 0.0;
        this.centroidW1 = 0.0;
        this.centroidW0 = 0.0;
        this.ringStart_z0 = 0.0;
        this.ringStart_y0 = 0.0;
        this.ringStart_x0 = 0.0;
        this.ringStart_\u03c600 = 0.0;
        this.ringStart_\u03bb00 = 0.0;
        this.lineStart_z0 = 0.0;
        this.lineStart_y0 = 0.0;
        this.lineStart_x0 = 0.0;
        Geo.INSTANCE.stream(feature, this.centroidStreamListener);
        double x = this.centroidX2;
        double y = this.centroidY2;
        double z = this.centroidZ2;
        double m = x * x + y * y + z * z;
        if (m < 1.0E-12) {
            x = this.centroidX1;
            y = this.centroidY1;
            z = this.centroidZ1;
            if (this.centroidW1 < 1.0E-6) {
                x = this.centroidX0;
                y = this.centroidY0;
                z = this.centroidZ0;
            }
            if ((m = x * x + y * y + z * z) < 1.0E-12) {
                return NULL_CENTROID;
            }
        }
        return new double[]{Math.atan2(y, x) * 57.29577951308232, Trigonometry.asin(z / Math.sqrt(m)) * 57.29577951308232};
    }
}

