/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.vida.rave.core.geo.InvertiblePointProjector;
import com.ibm.vida.rave.core.geo.PointProjector;
import com.ibm.vida.rave.core.geo.SphericalRotator;
import com.ibm.vida.rave.core.internal.math.Trigonometry;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class SphericalRotation {
    private static final InvertiblePointProjector identityRotation = new IdentityPointProjection();

    private SphericalRotation() {
    }

    public static SphericalRotator newRotator(double[] location) {
        InvertiblePointProjector rfo = SphericalRotation.rotation(location[0] % 360.0 * (Math.PI / 180), location[1] * (Math.PI / 180), location.length > 2 ? location[2] * (Math.PI / 180) : 0.0);
        SphericalRotatorImpl rotation = new SphericalRotatorImpl();
        rotation.init(rfo);
        return rotation;
    }

    public static PointProjector compose(PointProjector a, PointProjector b) {
        ComposedPointProjection obj = a.supportInversion() && b.supportInversion() ? new ComposedInvertiblePointProjector() : new ComposedPointProjection();
        obj.init(a, b);
        return obj;
    }

    public static InvertiblePointProjector rotation(double \u03b4\u03bb, double \u03b4\u03c6, double \u03b4\u03b3) {
        return ObjectConverter.toBoolean(\u03b4\u03bb) ? (ObjectConverter.toBoolean(\u03b4\u03c6) || ObjectConverter.toBoolean(\u03b4\u03b3) ? (InvertiblePointProjector)SphericalRotation.compose(SphericalRotation.rotation\u03bb(\u03b4\u03bb), SphericalRotation.rotation\u03c6\u03b3(\u03b4\u03c6, \u03b4\u03b3)) : SphericalRotation.rotation\u03bb(\u03b4\u03bb)) : (ObjectConverter.toBoolean(\u03b4\u03c6) || ObjectConverter.toBoolean(\u03b4\u03b3) ? SphericalRotation.rotation\u03c6\u03b3(\u03b4\u03c6, \u03b4\u03b3) : identityRotation);
    }

    private static InvertiblePointProjector rotation\u03bb(double \u03b4\u03bb) {
        PointProjectionLambda obj = new PointProjectionLambda();
        obj.init(\u03b4\u03bb);
        return obj;
    }

    private static InvertiblePointProjector rotation\u03c6\u03b3(double \u03b4\u03c6, double \u03b4\u03b3) {
        double cos\u03b4\u03c6 = Math.cos(\u03b4\u03c6);
        double sin\u03b4\u03c6 = Math.sin(\u03b4\u03c6);
        double cos\u03b4\u03b3 = Math.cos(\u03b4\u03b3);
        double sin\u03b4\u03b3 = Math.sin(\u03b4\u03b3);
        PointProjectionPhiGamma obj = new PointProjectionPhiGamma();
        obj.init(cos\u03b4\u03c6, sin\u03b4\u03c6, cos\u03b4\u03b3, sin\u03b4\u03b3);
        return obj;
    }

    private static final class PointProjectionPhiGamma
    implements InvertiblePointProjector {
        private double cos\u03b4\u03c6;
        private double sin\u03b4\u03c6;
        private double cos\u03b4\u03b3;
        private double sin\u03b4\u03b3;

        private PointProjectionPhiGamma() {
        }

        void init(double cos\u03b4\u03c6, double sin\u03b4\u03c6, double cos\u03b4\u03b3, double sin\u03b4\u03b3) {
            this.cos\u03b4\u03c6 = cos\u03b4\u03c6;
            this.sin\u03b4\u03c6 = sin\u03b4\u03c6;
            this.cos\u03b4\u03b3 = cos\u03b4\u03b3;
            this.sin\u03b4\u03b3 = sin\u03b4\u03b3;
        }

        @Override
        public double[] project(double \u03bb, double \u03c6) {
            double cos\u03c6 = Math.cos(\u03c6);
            double x = Math.cos(\u03bb) * cos\u03c6;
            double y = Math.sin(\u03bb) * cos\u03c6;
            double z = Math.sin(\u03c6);
            double k = z * this.cos\u03b4\u03c6 + x * this.sin\u03b4\u03c6;
            return new double[]{Math.atan2(y * this.cos\u03b4\u03b3 - k * this.sin\u03b4\u03b3, x * this.cos\u03b4\u03c6 - z * this.sin\u03b4\u03c6), Trigonometry.asin(k * this.cos\u03b4\u03b3 + y * this.sin\u03b4\u03b3)};
        }

        @Override
        public double[] invert(double \u03bb, double \u03c6) {
            double cos\u03c6 = Math.cos(\u03c6);
            double x = Math.cos(\u03bb) * cos\u03c6;
            double y = Math.sin(\u03bb) * cos\u03c6;
            double z = Math.sin(\u03c6);
            double k = z * this.cos\u03b4\u03b3 - y * this.sin\u03b4\u03b3;
            return new double[]{Math.atan2(y * this.cos\u03b4\u03b3 + z * this.sin\u03b4\u03b3, x * this.cos\u03b4\u03c6 + k * this.sin\u03b4\u03c6), Trigonometry.asin(k * this.cos\u03b4\u03c6 - x * this.sin\u03b4\u03c6)};
        }

        @Override
        public boolean supportInversion() {
            return true;
        }
    }

    private static final class PointProjectionLambda
    implements InvertiblePointProjector {
        private double \u03b4\u03bb;

        private PointProjectionLambda() {
        }

        void init(double \u03b4\u03bb) {
            this.\u03b4\u03bb = \u03b4\u03bb;
        }

        @Override
        public double[] project(double \u03bb, double \u03c6) {
            double _\u03bb = \u03bb;
            return new double[]{_\u03bb > Math.PI ? _\u03bb - Math.PI * 2 : (_\u03bb < -Math.PI ? _\u03bb + Math.PI * 2 : (_\u03bb += this.\u03b4\u03bb)), \u03c6};
        }

        @Override
        public double[] invert(double \u03bb, double \u03c6) {
            double _\u03bb = \u03bb;
            return new double[]{_\u03bb > Math.PI ? _\u03bb - Math.PI * 2 : (_\u03bb < -Math.PI ? _\u03bb + Math.PI * 2 : (_\u03bb -= this.\u03b4\u03bb)), \u03c6};
        }

        @Override
        public boolean supportInversion() {
            return true;
        }
    }

    private static final class ComposedInvertiblePointProjector
    extends ComposedPointProjection
    implements InvertiblePointProjector {
        private ComposedInvertiblePointProjector() {
        }

        @Override
        public double[] invert(double \u03bb, double \u03c6) {
            double[] x = ((InvertiblePointProjector)this.b).invert(\u03bb, \u03c6);
            if (x != null) {
                return ((InvertiblePointProjector)this.a).invert(x[0], x[1]);
            }
            return null;
        }

        @Override
        public boolean supportInversion() {
            return true;
        }
    }

    private static class ComposedPointProjection
    implements PointProjector {
        protected PointProjector a;
        protected PointProjector b;

        private ComposedPointProjection() {
        }

        public void init(PointProjector a, PointProjector b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public double[] project(double \u03bb, double \u03c6) {
            double[] x = this.a.project(\u03bb, \u03c6);
            return this.b.project(x[0], x[1]);
        }

        @Override
        public boolean supportInversion() {
            return false;
        }
    }

    private static final class IdentityPointProjection
    implements InvertiblePointProjector {
        private IdentityPointProjection() {
        }

        @Override
        public double[] project(double \u03bb, double \u03c6) {
            return new double[]{\u03bb > Math.PI ? \u03bb - Math.PI * 2 : (\u03bb < -Math.PI ? \u03bb + Math.PI * 2 : \u03bb), \u03c6};
        }

        @Override
        public double[] invert(double \u03bb, double \u03c6) {
            return new double[]{\u03bb, \u03c6};
        }

        @Override
        public boolean supportInversion() {
            return true;
        }
    }

    private static final class SphericalRotatorImpl
    implements SphericalRotator {
        private InvertiblePointProjector pointProjection;

        private SphericalRotatorImpl() {
        }

        void init(InvertiblePointProjector pointProjection) {
            this.pointProjection = pointProjection;
        }

        @Override
        public double[] rotate(double[] coordinates) {
            double[] _coordinates = coordinates;
            _coordinates = this.pointProjection.project(_coordinates[0] * (Math.PI / 180), _coordinates[1] * (Math.PI / 180));
            _coordinates[0] = _coordinates[0] * 57.29577951308232;
            _coordinates[1] = _coordinates[1] * 57.29577951308232;
            return _coordinates;
        }

        @Override
        public double[] invert(double[] coordinates) {
            double[] _coordinates = coordinates;
            _coordinates = this.pointProjection.invert(_coordinates[0] * (Math.PI / 180), _coordinates[1] * (Math.PI / 180));
            _coordinates[0] = _coordinates[0] * 57.29577951308232;
            _coordinates[1] = _coordinates[1] * 57.29577951308232;
            return _coordinates;
        }
    }
}

