/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geo;

import com.ibm.vida.rave.core.geo.InvertiblePointProjector;
import com.ibm.vida.rave.core.geo.InvertibleProjection;
import com.ibm.vida.rave.core.geo.PlaneProjectionFactory;
import com.ibm.vida.rave.core.geo.PointProjector;
import com.ibm.vida.rave.core.internal.geo.ProjectionMutatorImpl;
import com.ibm.vida.rave.core.internal.geo.TransverseMercatorProjection;

public final class TransverseMercatorProjectionFactory
implements PlaneProjectionFactory {
    public static final TransverseMercatorProjectionFactory INSTANCE = new TransverseMercatorProjectionFactory();
    private final PointProjector raw = new InvertiblePointProjector(){

        @Override
        public boolean supportInversion() {
            return true;
        }

        @Override
        public double[] project(double \u03bb, double \u03c6) {
            return new double[]{Math.log(Math.tan(0.7853981633974483 + \u03c6 / 2.0)), -\u03bb};
        }

        @Override
        public double[] invert(double x, double y) {
            return new double[]{-y, 2.0 * Math.atan(Math.exp(x)) - 1.5707963267948966};
        }
    };

    private TransverseMercatorProjectionFactory() {
    }

    @Override
    public InvertibleProjection create() {
        TransverseMercatorProjection m = new TransverseMercatorProjection();
        ProjectionMutatorImpl.internalMutate(m, this.raw);
        m.init();
        return m;
    }

    @Override
    public final PointProjector getRaw() {
        return this.raw;
    }
}

