/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geom.voronoi;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.geom.voronoi.VoronoiContext;
import com.ibm.vida.rave.core.internal.geom.voronoi.VoronoiEdge;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.util.Comparator;

public class VoronoiCell {
    public VoronoiEdge.VoronoiSite site;
    public ArrayEx<VoronoiEdge.VoronoiHalfEdge> edges;
    public static final Comparator<VoronoiEdge.VoronoiHalfEdge> voronoiHalfEdgeOrder = new Comparator<VoronoiEdge.VoronoiHalfEdge>(){

        @Override
        public int compare(VoronoiEdge.VoronoiHalfEdge a, VoronoiEdge.VoronoiHalfEdge b) {
            if (b.angle > a.angle) {
                return 1;
            }
            if (b.angle < a.angle) {
                return -1;
            }
            return 0;
        }
    };

    public VoronoiCell(VoronoiEdge.VoronoiSite site) {
        this.site = site;
        this.edges = new ArrayEx();
    }

    public int prepare() {
        ArrayEx<VoronoiEdge.VoronoiHalfEdge> halfEdges = this.edges;
        int iHalfEdge = halfEdges.length();
        while (iHalfEdge-- > 0) {
            VoronoiEdge edge = ((VoronoiEdge.VoronoiHalfEdge)halfEdges.get((int)iHalfEdge)).edge;
            if (edge.getB() != null && edge.getA() != null) continue;
            halfEdges.splice(iHalfEdge, 1, (VoronoiEdge.VoronoiHalfEdge[])new VoronoiEdge.VoronoiHalfEdge[0]);
        }
        halfEdges.sort(voronoiHalfEdgeOrder);
        return halfEdges.length();
    }

    public static void voronoiCloseCells(VoronoiContext context, double[][] extent) {
        double x0 = extent[0][0];
        double x1 = extent[1][0];
        double y0 = extent[0][1];
        double y1 = extent[1][1];
        ArrayEx<VoronoiCell> cells = context.voronoiCells;
        int iCell = cells.length();
        while (iCell-- > 0) {
            VoronoiCell cell = (VoronoiCell)cells.get(iCell);
            if (!ObjectConverter.toBoolean(cell) || !ObjectConverter.toBoolean(cell.prepare())) continue;
            ArrayEx<VoronoiEdge.VoronoiHalfEdge> halfEdges = cell.edges;
            int nHalfEdges = halfEdges.length();
            int iHalfEdge = 0;
            while (iHalfEdge < nHalfEdges) {
                VoronoiEdge.VoronoiSite end = ((VoronoiEdge.VoronoiHalfEdge)halfEdges.get(iHalfEdge)).end();
                double x3 = end.x;
                double y3 = end.y;
                VoronoiEdge.VoronoiSite start = ((VoronoiEdge.VoronoiHalfEdge)halfEdges.get(++iHalfEdge % nHalfEdges)).start();
                double x2 = start.x;
                double y2 = start.y;
                if (!(Math.abs(x3 - x2) > 1.0E-6) && !(Math.abs(y3 - y2) > 1.0E-6)) continue;
                halfEdges.splice(iHalfEdge, 0, (VoronoiEdge.VoronoiHalfEdge[])new VoronoiEdge.VoronoiHalfEdge[]{new VoronoiEdge.VoronoiHalfEdge(VoronoiEdge.voronoiCreateBorderEdge(context, cell.site, end, Math.abs(x3 - x0) < 1.0E-6 && y1 - y3 > 1.0E-6 ? new VoronoiEdge.VoronoiSite(x0, Math.abs(x2 - x0) < 1.0E-6 ? y2 : y1) : (Math.abs(y3 - y1) < 1.0E-6 && x1 - x3 > 1.0E-6 ? new VoronoiEdge.VoronoiSite(Math.abs(y2 - y1) < 1.0E-6 ? x2 : x1, y1) : (Math.abs(x3 - x1) < 1.0E-6 && y3 - y0 > 1.0E-6 ? new VoronoiEdge.VoronoiSite(x1, Math.abs(x2 - x1) < 1.0E-6 ? y2 : y0) : (Math.abs(y3 - y0) < 1.0E-6 && x3 - x0 > 1.0E-6 ? new VoronoiEdge.VoronoiSite(Math.abs(y2 - y0) < 1.0E-6 ? x2 : x0, y0) : null)))), cell.site, null)});
                ++nHalfEdges;
            }
        }
    }
}

