/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.geom.voronoi;

import com.ibm.vida.rave.core.geom.Line;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.internal.geom.voronoi.VoronoiCell;
import com.ibm.vida.rave.core.internal.geom.voronoi.VoronoiContext;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public class VoronoiEdge
extends Line {
    public VoronoiSite l = null;
    public VoronoiSite r = null;

    public VoronoiEdge(VoronoiSite lSite, VoronoiSite rSite) {
        super(null, null);
        this.l = lSite;
        this.r = rSite;
        this.setA(null);
        this.setB(null);
    }

    public static VoronoiEdge voronoiCreateEdge(VoronoiContext context, VoronoiSite lSite, VoronoiSite rSite, VoronoiSite va, VoronoiSite vb) {
        VoronoiEdge edge = new VoronoiEdge(lSite, rSite);
        context.voronoiEdges.push((VoronoiEdge[])new VoronoiEdge[]{edge});
        if (ObjectConverter.toBoolean(va)) {
            VoronoiEdge.voronoiSetEdgeEnd(edge, lSite, rSite, va);
        }
        if (ObjectConverter.toBoolean(vb)) {
            VoronoiEdge.voronoiSetEdgeEnd(edge, rSite, lSite, vb);
        }
        ((VoronoiCell)context.voronoiCells.get((int)lSite.i)).edges.push((VoronoiHalfEdge[])new VoronoiHalfEdge[]{new VoronoiHalfEdge(edge, lSite, rSite)});
        ((VoronoiCell)context.voronoiCells.get((int)rSite.i)).edges.push((VoronoiHalfEdge[])new VoronoiHalfEdge[]{new VoronoiHalfEdge(edge, rSite, lSite)});
        return edge;
    }

    public static void voronoiSetEdgeEnd(VoronoiEdge edge, VoronoiSite lSite, VoronoiSite rSite, VoronoiSite vertex) {
        if (edge.getA() == null && edge.getB() == null) {
            edge.setA(vertex);
            edge.l = lSite;
            edge.r = rSite;
        } else if (edge.l == rSite) {
            edge.setB(vertex);
        } else {
            edge.setA(vertex);
        }
    }

    public static VoronoiEdge voronoiCreateBorderEdge(VoronoiContext context, VoronoiSite lSite, VoronoiSite va, VoronoiSite vb) {
        VoronoiEdge edge = new VoronoiEdge(lSite, null);
        edge.setA(va);
        edge.setB(vb);
        context.voronoiEdges.push((VoronoiEdge[])new VoronoiEdge[]{edge});
        return edge;
    }

    public static class VoronoiHalfEdge {
        public VoronoiEdge edge = null;
        public VoronoiSite site = null;
        public double angle;

        public VoronoiHalfEdge(VoronoiEdge edge, VoronoiSite lSite, VoronoiSite rSite) {
            PointStruct va = edge.getA();
            PointStruct vb = edge.getB();
            this.edge = edge;
            this.site = lSite;
            this.angle = rSite != null ? Math.atan2(rSite.y - lSite.y, rSite.x - lSite.x) : (edge.l == lSite ? Math.atan2(vb.x - va.x, va.y - vb.y) : Math.atan2(va.x - vb.x, vb.y - va.y));
        }

        public VoronoiSite start() {
            return this.edge.l == this.site ? (VoronoiSite)this.edge.getA() : (VoronoiSite)this.edge.getB();
        }

        public VoronoiSite end() {
            return this.edge.l == this.site ? (VoronoiSite)this.edge.getB() : (VoronoiSite)this.edge.getA();
        }
    }

    public static class VoronoiSite
    extends PointStruct {
        public int i;

        public VoronoiSite(double x, double y) {
            super(x, y);
        }
    }
}

