/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.globalization;

import com.ibm.vida.rave.core.internal.globalization.AbstractNumericShaper;

public class ContextualNumericShaper
extends AbstractNumericShaper {
    private final int[] contextualDigitCodes;
    private final int startingContextCode;
    private static final int EUROPEAN = 0;
    private static final int ARABIC = 1;
    private static final int EASTERN_ARABIC = 2;
    private static final int EXTENDED_ARABIC = 19;
    private static final CodePointRange[] contextualCharRanges = new CodePointRange[]{new CodePointRange(65, 91), new CodePointRange(97, 123), new CodePointRange(170, 171), new CodePointRange(181, 182), new CodePointRange(186, 187), new CodePointRange(192, 215), new CodePointRange(216, 247), new CodePointRange(248, 697), new CodePointRange(699, 706), new CodePointRange(720, 722), new CodePointRange(736, 741), new CodePointRange(750, 751), new CodePointRange(1544, 1545), new CodePointRange(1547, 1548), new CodePointRange(1549, 1550), new CodePointRange(1563, 1611), new CodePointRange(1645, 1648), new CodePointRange(1649, 1750), new CodePointRange(1765, 1767), new CodePointRange(1774, 1776), new CodePointRange(1786, 1793), new CodePointRange(1872, 1921), new CodePointRange(2307, 2362), new CodePointRange(2363, 2364), new CodePointRange(2365, 2369), new CodePointRange(2377, 2381), new CodePointRange(2382, 2385), new CodePointRange(2392, 2402), new CodePointRange(2404, 2433), new CodePointRange(2434, 2492), new CodePointRange(2493, 2497), new CodePointRange(2503, 2509), new CodePointRange(2510, 2530), new CodePointRange(2534, 2546), new CodePointRange(2548, 2555), new CodePointRange(2563, 2620), new CodePointRange(2622, 2625), new CodePointRange(2649, 2672), new CodePointRange(2674, 2677), new CodePointRange(2691, 2748), new CodePointRange(2749, 2753), new CodePointRange(2761, 2765), new CodePointRange(2768, 2786), new CodePointRange(2790, 2801), new CodePointRange(2818, 2876), new CodePointRange(2877, 2879), new CodePointRange(2880, 2881), new CodePointRange(2887, 2893), new CodePointRange(2903, 2914), new CodePointRange(2918, 2946), new CodePointRange(2947, 3008), new CodePointRange(3009, 3021), new CodePointRange(3024, 3059), new CodePointRange(3073, 3134), new CodePointRange(3137, 3142), new CodePointRange(3160, 3170), new CodePointRange(3174, 3192), new CodePointRange(3199, 3260), new CodePointRange(3261, 3276), new CodePointRange(3285, 3298), new CodePointRange(3302, 3393), new CodePointRange(3398, 3405), new CodePointRange(3406, 3426), new CodePointRange(3430, 3457), new CodePointRange(3584, 3633), new CodePointRange(3634, 3636), new CodePointRange(3648, 3655), new CodePointRange(3663, 3761), new CodePointRange(3762, 3764), new CodePointRange(3773, 3784), new CodePointRange(3792, 3864), new CodePointRange(3866, 3893), new CodePointRange(3894, 3895), new CodePointRange(3896, 3897), new CodePointRange(3902, 3953), new CodePointRange(3967, 3968), new CodePointRange(3973, 3974), new CodePointRange(3976, 3981), new CodePointRange(4030, 4038), new CodePointRange(4039, 4141), new CodePointRange(4145, 4146), new CodePointRange(4152, 4153), new CodePointRange(4155, 4157), new CodePointRange(4159, 4184), new CodePointRange(4186, 4190), new CodePointRange(4193, 4209), new CodePointRange(4213, 4225), new CodePointRange(4608, 4957), new CodePointRange(4960, 4993), new CodePointRange(6016, 6071), new CodePointRange(6078, 6086), new CodePointRange(6087, 6089), new CodePointRange(6100, 6107), new CodePointRange(6108, 6109), new CodePointRange(6112, 6128), new CodePointRange(6160, 6313), new CodePointRange(6314, 6401)};
    private static CodePointRange[] ranges = new CodePointRange[]{new CodePointRange(0, 768), new CodePointRange(1536, 1792), new CodePointRange(1536, 1792), new CodePointRange(2304, 2432), new CodePointRange(2432, 2560), new CodePointRange(2560, 2688), new CodePointRange(2688, 2816), new CodePointRange(2816, 2944), new CodePointRange(2944, 3072), new CodePointRange(3072, 3200), new CodePointRange(3200, 3328), new CodePointRange(3328, 3456), new CodePointRange(3584, 3712), new CodePointRange(3712, 3840), new CodePointRange(3840, 4096), new CodePointRange(4096, 4256), new CodePointRange(4608, 5024), new CodePointRange(6016, 6144), new CodePointRange(6144, 6320), new CodePointRange(1872, 1920)};

    protected ContextualNumericShaper(int[] contextualDigitCodes, int startingContextCode) {
        this.contextualDigitCodes = contextualDigitCodes;
        this.startingContextCode = startingContextCode;
    }

    private static boolean hasContext(int charValue) {
        int searchIndex = ContextualNumericShaper.search(contextualCharRanges, charValue);
        return searchIndex != -1;
    }

    private static int getRange(int charValue) {
        int index = ContextualNumericShaper.search(ranges, charValue);
        if (index == -1) {
            return 0;
        }
        if (index == 19) {
            return 1;
        }
        return index;
    }

    @Override
    public String shape(String text) {
        if (text == null) {
            return null;
        }
        int[] contextCodes = this.contextualDigitCodes;
        int contexts = 0;
        for (int i = 0; i < contextCodes.length; ++i) {
            contexts |= 1 << contextCodes[i];
        }
        StringBuilder s = new StringBuilder();
        int offset = 0;
        int range = 0;
        if ((1 << this.startingContextCode & contexts) != 0) {
            offset = offsets[this.startingContextCode];
            range = this.startingContextCode;
        }
        for (int i = 0; i < text.length(); ++i) {
            int c = Character.codePointAt(text, i);
            int minDigit = 48;
            int maxDigit = 57;
            if (c >= minDigit && c <= maxDigit) {
                s.append(Character.toString((char)(c + offset)));
                continue;
            }
            s.append(Character.toString((char)c));
            int newRange = ContextualNumericShaper.getRange(c);
            if (newRange == range || !ContextualNumericShaper.hasContext(c)) continue;
            if ((1 << newRange & contexts) != 0) {
                range = newRange;
                if (range == 1 && (contexts & 4) != 0) {
                    range = 2;
                }
                offset = offsets[range];
                continue;
            }
            if ((1 << newRange & contexts) != 0) continue;
            if (newRange == 2) {
                if ((2 & contexts) == 0) continue;
                range = 1;
                offset = offsets[range];
                continue;
            }
            if (newRange == 1) {
                if ((4 & contexts) == 0) continue;
                range = 2;
                offset = offsets[range];
                continue;
            }
            range = 0;
            offset = 0;
        }
        return s.toString();
    }

    private static int search(CodePointRange[] pRanges, int charValue) {
        int start = 0;
        int end = pRanges.length - 1;
        while (start <= end) {
            int mid = (int)Math.floor((start + end) / 2);
            if (pRanges[mid].start <= charValue && pRanges[mid].end > charValue) {
                return mid;
            }
            if (pRanges[mid].start > charValue) {
                end = mid - 1;
                continue;
            }
            if (pRanges[mid].end > charValue) continue;
            start = mid + 1;
        }
        return -1;
    }

    private static class CodePointRange {
        public final int start;
        public final int end;

        public CodePointRange(int s, int e) {
            this.start = s;
            this.end = e;
        }
    }
}

