/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.globalization;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.globalization.BidiStringFormatter;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.globalization.AbstractNumericShaper;
import com.ibm.vida.rave.core.internal.globalization.ContextualNumericShaper;
import com.ibm.vida.rave.core.internal.globalization.DefaultNumericShaper;
import com.ibm.vida.rave.core.internal.globalization.NationalNumericShaper;
import java.util.List;

public final class NumericShaperFactory {
    static final String EUROPEAN = "EUROPEAN";
    private static final String NATIONAL = "nation";
    private static final String CONTEXTUAL = "context";
    private static OMap<String, Integer> digitMap = NumericShaperFactory.initialize_digitMap();

    private static OMap<String, Integer> initialize_digitMap() {
        OMap<String, Integer> digitMap = new OMap<String, Integer>();
        digitMap.put("ARABIC", 1);
        digitMap.put("BENGALI", 4);
        digitMap.put("DEVANAGARI", 3);
        digitMap.put("EASTERN_ARABIC", 2);
        digitMap.put("ETHIOPIC", 16);
        digitMap.put(EUROPEAN, 0);
        digitMap.put("GUJARATI", 6);
        digitMap.put("GURMUKHI", 5);
        digitMap.put("KANNADA", 10);
        digitMap.put("KHMER", 17);
        digitMap.put("LAO", 13);
        digitMap.put("MALAYALAM", 11);
        digitMap.put("MONGOLIAN", 18);
        digitMap.put("MYANMAR", 15);
        digitMap.put("ORIYA", 7);
        digitMap.put("TAMIL", 8);
        digitMap.put("TELUGU", 9);
        digitMap.put("THAI", 12);
        digitMap.put("TIBETAN", 14);
        return digitMap;
    }

    public static AbstractNumericShaper create(BidiStringFormatter formatter) {
        ArrayEx<String> digits = formatter.digitMapping();
        String shaping = formatter.numericShaping();
        if (digits.size() > 0 && shaping != null) {
            if ((shaping = shaping.toLowerCase()).indexOf(NATIONAL) == 0) {
                return new NationalNumericShaper(NumericShaperFactory.getDigitCode((String)digits.get(0)));
            }
            if (shaping.indexOf(CONTEXTUAL) == 0) {
                return new ContextualNumericShaper(NumericShaperFactory.getDigitCodes(formatter.digitMapping()), NumericShaperFactory.getDigitCode(formatter.defaultContext()));
            }
        }
        return new DefaultNumericShaper();
    }

    private static int getDigitCode(String nationalDigits) {
        Integer digit = digitMap.get(nationalDigits.toUpperCase());
        if (digit == null) {
            return digitMap.get(EUROPEAN);
        }
        return digit;
    }

    private static int[] getDigitCodes(List<String> list) {
        int[] digits = new int[list.size()];
        int i = 0;
        for (String digitStr : list) {
            digits[i++] = NumericShaperFactory.getDigitCode(digitStr);
        }
        return digits;
    }
}

