/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.math;

import com.ibm.vida.rave.core.collections.ArrayEx;

public final class Trigonometry {
    public static final double \u03c0 = Math.PI;
    public static final double \u03c4 = Math.PI * 2;
    public static final double half\u03c0 = 1.5707963267948966;
    public static final double \u03b5 = 1.0E-6;
    public static final double \u03b52 = 1.0E-12;
    public static final double radians = Math.PI / 180;
    public static final double degrees = 57.29577951308232;
    public static final double \u03c4\u03b5 = 6.283184307179586;

    private Trigonometry() {
    }

    public static int sgn(double x) {
        return x > 0.0 ? 1 : (x < 0.0 ? -1 : 0);
    }

    public static double cross2d(ArrayEx<Double> a, ArrayEx<Double> b, ArrayEx<Double> c) {
        return ((Double)b.get(0) - (Double)a.get(0)) * ((Double)c.get(1) - (Double)a.get(1)) - ((Double)b.get(1) - (Double)a.get(1)) * ((Double)c.get(0) - (Double)a.get(0));
    }

    public static double acos(double x) {
        return x > 1.0 ? 0.0 : (x < -1.0 ? Math.PI : Math.acos(x));
    }

    public static double asin(double x) {
        return x > 1.0 ? 1.5707963267948966 : (x < -1.0 ? -1.5707963267948966 : Math.asin(x));
    }

    public static double sinh(double x) {
        double _x = x;
        _x = Math.exp(_x);
        return (_x - 1.0 / _x) / 2.0;
    }

    public static double cosh(double x) {
        double _x = x;
        _x = Math.exp(_x);
        return (_x + 1.0 / _x) / 2.0;
    }

    public static double tanh(double x) {
        double _x = x;
        _x = Math.exp(2.0 * _x);
        return (_x - 1.0) / (_x + 1.0);
    }

    public static double haversin(double x) {
        double _x = x;
        _x = Math.sin(_x / 2.0);
        return _x * _x;
    }

    public static double sinci(double x) {
        return x != 0.0 ? x / Math.sin(x) : 1.0;
    }
}

