/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.nativeImpl;

import com.ibm.vida.rave.core.format.Round;
import com.ibm.vida.rave.core.internal.format.Precision;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumberFormatHelper {
    public static String toExponential(double value, Integer precision) {
        DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
        if (value > 0.0 && value < 1.0) {
            SYMBOLS.setExponentSeparator("e");
        } else {
            SYMBOLS.setExponentSeparator("e+");
        }
        DecimalFormat format = new DecimalFormat("0.###E0", SYMBOLS);
        if (precision != null) {
            format.setMaximumFractionDigits(precision);
            format.setMinimumFractionDigits(precision);
        }
        return format.format(value);
    }

    public static String toExponential(double value) {
        return NumberFormatHelper.toExponential(value, null);
    }

    public static String toFixed(double value, int scale) {
        BigDecimal number = new BigDecimal(value);
        BigDecimal bigNumber = number.setScale(scale, 4);
        return bigNumber.toString();
    }

    public static double toScale(double value, Integer precision, int scale) {
        BigDecimal number = new BigDecimal(Round.round(value, Precision.precision(value, precision)));
        return number.setScale(scale, 4).doubleValue();
    }

    public static String toPrecision(double value, Integer precision) {
        if (precision != null) {
            return String.format("%." + (precision > 0 ? precision : 16) + "g", value).replace("e+0", "e+").replace("e-0", "e-");
        }
        if (value == Math.floor(value) && !Double.isInfinite(value)) {
            return String.format("%.0f", value).replace("e+0", "e+").replace("e-0", "e-");
        }
        return Double.toString(value);
    }

    public static double fromExponential(double value) {
        DecimalFormat formatter = new DecimalFormat("#0.00");
        return ObjectConverter.toDouble(formatter.format(value));
    }
}

