/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.nativeImpl;

import com.ibm.vida.rave.core.collections.ArrayEx;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegExp {
    public static final String CASE_INSENSITIVE = "i";
    public static final String MULTILINE = "m";
    public static final String GLOBAL = "g";
    private static String WHITESPACE = " \t\n";
    private static String WORD = "[0-9a-zA-z_]";
    private final Pattern pattern;
    public int lastIndex;
    public final String source;
    private boolean isGlobal = false;

    public RegExp(String regex, String modifiers) {
        this.source = RegExp.fixup(regex);
        int flags = 0;
        if (modifiers != null && modifiers.length() > 0) {
            if (modifiers.contains(CASE_INSENSITIVE)) {
                flags |= 2;
            }
            if (modifiers.contains(MULTILINE)) {
                flags |= 8;
            }
            if (modifiers.contains(GLOBAL)) {
                this.isGlobal = true;
            }
        }
        this.pattern = Pattern.compile(this.source, flags);
    }

    private static String fixup(String regex) {
        return regex.replaceAll("\\\\s", "[" + WHITESPACE + "]").replaceAll("\\\\w", WORD);
    }

    public RegExpResult exec(String str) {
        RegExpResult result = null;
        if (str.length() > 0 && this.lastIndex >= str.length()) {
            this.lastIndex = 0;
            return null;
        }
        Matcher matcher = this.pattern.matcher(str);
        matcher.region(this.lastIndex, str.length());
        if (matcher.find(this.lastIndex)) {
            int groupCount = matcher.groupCount();
            result = new RegExpResult(str);
            for (int group = 0; group <= groupCount; ++group) {
                result.add(matcher.group(group));
            }
            result.index = matcher.start();
            this.lastIndex = matcher.end();
        } else {
            this.lastIndex = str.length();
        }
        if (!this.isGlobal) {
            this.lastIndex = 0;
        }
        return result;
    }

    public boolean test(String str) {
        RegExpResult result = this.exec(str);
        return result == null ? false : result.size() > 0;
    }

    public static final class RegExpResult
    extends ArrayEx<String> {
        public int index;
        public final String input;

        public RegExpResult(String input) {
            this.input = input;
        }
    }
}

