/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.nativeImpl.xhr;

import com.ibm.vida.rave.core.context.RaveOperationalMode;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.timer.Timer;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.vida.rave.core.nativeImpl.xhr.Xhr;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrResult;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.FileNameMap;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;

public class XhrRunnable
implements Runnable {
    private Thread thread;
    private final String url;
    private OMap<String, String> headers = new OMap();
    private String mimeType;
    private String responseType;
    private String method = "GET";
    private String data;
    private Xhr.Callback<XhrResult> callback;
    private final XhrResult result = new XhrResult();
    private static final int TEXT = 0;
    private static final int IMAGE = 1;
    private static final int BINARY = 2;
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0";

    @Override
    public void run() {
        try {
            if (this.url.toLowerCase().startsWith("http")) {
                this.processHttpRequest();
            } else {
                this.result.status = 200;
                this.processLocalRequest();
            }
        }
        catch (Exception e) {
            this.result.message = this.result.statusText = e.getMessage();
            this.callback.callback(this.result, null);
            return;
        }
        if (this.result.status >= 200 && this.result.status < 300 || this.result.status == 304) {
            this.callback.callback(null, this.result);
        } else {
            this.callback.callback(this.result, null);
        }
    }

    public XhrRunnable(String url, Xhr.Callback<XhrResult> respondCallback) {
        this.url = url;
        this.callback = respondCallback;
    }

    public XhrRunnable headers(OMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public XhrRunnable mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public XhrRunnable method(String method) {
        this.method = method;
        return this;
    }

    public XhrRunnable responseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    public String responseType() {
        return this.responseType;
    }

    public XhrRunnable data(String data) {
        this.data = data;
        return this;
    }

    public void start() {
        if (RaveOperationalMode.MODE == 1) {
            final Xhr.Callback<XhrResult> originalCallback = this.callback;
            this.callback = new Xhr.Callback<XhrResult>(){

                @Override
                public void callback(final XhrResult error, final XhrResult response) {
                    Timer.INSTANCE.addEvent(new TimerEvent(){

                        @Override
                        public boolean run(double elapsed) {
                            originalCallback.callback(error, response);
                            return true;
                        }
                    });
                }
            };
            this.run();
        } else {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void abort() {
    }

    private void processHttpRequest() throws Exception {
        URL obj = new URL(this.url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod(this.method);
        con.setRequestProperty("User-Agent", DEFAULT_USER_AGENT);
        for (String key : this.headers.keySet()) {
            con.setRequestProperty(key, this.headers.get(key));
        }
        if (this.mimeType != null) {
            con.setRequestProperty("Accept", this.mimeType);
        }
        if (this.data != null) {
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(this.data);
            wr.flush();
            wr.close();
        }
        this.processInput(con);
    }

    private void processInput(HttpURLConnection con) throws Exception {
        this.result.status = con.getResponseCode();
        this.result.statusText = con.getResponseMessage();
        this.responseType = this.result.contentType = con.getContentType();
        int type = 0;
        if (this.result.contentType != null) {
            if (this.result.contentType.contains("image")) {
                type = 1;
            } else if (!(this.result.contentType.contains("text") || this.result.contentType.contains("html") || this.result.contentType.contains("xml") || this.result.contentType.contains("json"))) {
                type = 2;
            }
        }
        if (this.result.status >= 200 && this.result.status < 300 || this.result.status == 304) {
            if (type == 1) {
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                this.result.binary = ImageIO.read(in);
                in.close();
            } else if (type == 2) {
                int c;
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    byteArrayOut.write(c);
                }
                this.result.binary = byteArrayOut.toByteArray();
                in.close();
            } else {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder inBuffer = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    inBuffer.append(inputLine + "\n");
                }
                if (type == 0) {
                    this.result.responseText = inBuffer.toString();
                }
                in.close();
            }
        } else {
            this.result.message = this.result.statusText;
        }
    }

    private void processLocalRequest() throws Exception {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String modifiedURL = this.url;
        if (modifiedURL.toLowerCase().startsWith("file://")) {
            modifiedURL = this.url.substring(7);
        }
        this.result.contentType = fileNameMap.getContentTypeFor(modifiedURL);
        int type = 0;
        if (this.result.contentType != null) {
            if (this.result.contentType.contains("image")) {
                type = 1;
            } else if (!(this.result.contentType.contains("text") || this.result.contentType.contains("html") || this.result.contentType.contains("xml") || this.result.contentType.contains("json"))) {
                type = 2;
            }
        }
        File file = new File(modifiedURL);
        FileInputStream fis = new FileInputStream(file);
        if (type == 1) {
            BufferedInputStream in = new BufferedInputStream(fis);
            this.result.binary = ImageIO.read(in);
            in.close();
        } else if (type == 2) {
            int c;
            BufferedInputStream in = new BufferedInputStream(fis);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                byteArrayOut.write(c);
            }
            this.result.binary = byteArrayOut.toByteArray();
            in.close();
        } else {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            StringBuilder inBuffer = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                inBuffer.append(inputLine + "\n");
            }
            this.result.responseText = inBuffer.toString();
            in.close();
        }
    }
}

