/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.scales;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.scales.NiceIdentity;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public class Nice {
    public static ArrayEx<Object> scaleNice(ArrayEx<Object> domain, NiceIdentity nice) {
        Number i0 = 0.0;
        Number i1 = domain.size() - 1;
        Double x0 = ObjectConverter.toDouble(domain.get(((Number)i0).intValue()));
        Double x1 = ObjectConverter.toDouble(domain.get(i1.intValue()));
        if (x1 < x0) {
            Double dx = i0;
            i0 = i1;
            i1 = dx;
            dx = x0;
            x0 = x1;
            x1 = dx;
        }
        domain.set(((Number)i0).intValue(), nice.floor.getValue((double)x0));
        domain.set(i1.intValue(), nice.ceil.getValue((double)x1));
        return domain;
    }

    public static NiceIdentity niceStep(Object step) {
        final Double doubleStep = ObjectConverter.toDouble(step);
        return doubleStep != 0.0 ? new NiceIdentity(new ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return Math.floor(ObjectConverter.toDouble(x) / doubleStep) * doubleStep;
            }
        }, new ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return Math.ceil(ObjectConverter.toDouble(x) / doubleStep) * doubleStep;
            }
        }) : new NiceIdentity();
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface ValueFunction {
        public Number getValue(Number var1);
    }
}

