/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.scales;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.internal.scales.LinearValueFunction;
import com.ibm.vida.rave.core.interpolate.Interpolator;
import com.ibm.vida.rave.core.interpolate.InterpolatorFactory;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import java.util.ArrayList;
import java.util.List;

@FunctionClass(value="getValue")
public class Polylinear
implements LinearValueFunction {
    @Override
    public SingleValueFunction<Object, Object> getValue(List<Object> domain, List<Object> range, InterpolatorFactory<Object> uninterpolate, InterpolatorFactory<Object> interpolate) {
        return new PolylinearValuefunction(domain, range, uninterpolate, interpolate);
    }

    public class PolylinearValuefunction
    implements SingleValueFunction<Object, Object> {
        List<Interpolator<?>> u = new ArrayList();
        List<Interpolator<?>> i = new ArrayList();
        int k;
        ArrayEx<Object> domain;
        ArrayEx<Object> range;

        public PolylinearValuefunction(List<Object> inDomain, List<Object> inRange, InterpolatorFactory<Object> uninterpolate, InterpolatorFactory<Object> interpolate) {
            int j = 0;
            this.domain = new ArrayEx();
            for (Object o : inDomain) {
                this.domain.add(o);
            }
            this.range = new ArrayEx();
            for (Object o : inRange) {
                this.range.add(o);
            }
            this.k = Math.min(this.domain.size(), this.range.size()) - 1;
            if (ObjectConverter.toDouble(this.domain.get(this.k)) < ObjectConverter.toDouble(this.domain.get(0))) {
                this.domain = this.domain.slice().reverse();
                this.range = this.range.slice().reverse();
            }
            while (++j <= this.k) {
                this.u.add(uninterpolate.create(this.domain.get(j - 1), this.domain.get(j)));
                this.i.add(interpolate.create(this.range.get(j - 1), this.range.get(j)));
            }
        }

        @Override
        public Object getValue(Object x) {
            int j = Rave.bisect.bisect(this.domain, x, 1, this.k) - 1;
            return this.i.get(j).interpolate(ObjectConverter.toDouble(this.u.get(j).interpolate(ObjectConverter.toDouble(x))));
        }
    }
}

