/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.selector;

import com.ibm.vida.rave.core.Configuration;
import com.ibm.vida.rave.core.internal.util.QueryUtil;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.SelectorGroup;
import com.ibm.vida.rave.core.selector.ValueFunction;
import java.util.List;

public final class SelectorHelper {
    public static <T extends Selection<T>> T each(T selection, CallbackFunction<? super SceneNode> callback) {
        int m = selection.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)selection.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                SceneNode node = (SceneNode)group.get(i);
                if (node == null) continue;
                callback.run(node, node.getData(), i, j);
            }
        }
        return selection;
    }

    public static ValueFunction<SceneNode, SceneNode> selector(final Object selector) {
        return selector instanceof ValueFunction ? (ValueFunction<Object, Object>)selector : new ValueFunction<SceneNode, SceneNode>(){

            @Override
            public SceneNode getValue(SceneNode node, Object data, int index, int groupIndex) {
                return selector != null ? Configuration.INSTANCE.filter(QueryUtil.getQueryEngine(node).querySelector((String)selector, node), (String)selector) : null;
            }
        };
    }

    public static ValueFunction<SceneNode, List<SceneNode>> selectorAll(final Object selector) {
        return selector instanceof ValueFunction ? (ValueFunction<Object, Object>)selector : new ValueFunction<SceneNode, List<SceneNode>>(){

            @Override
            public List<SceneNode> getValue(SceneNode node, Object data, int index, int groupIndex) {
                return selector != null ? Configuration.INSTANCE.filterArray(QueryUtil.getQueryEngine(node).querySelectorAll((String)selector, node)) : null;
            }
        };
    }
}

