/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.selector.mirror;

import com.ibm.vida.rave.core.Configuration;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.scene.SceneNodeUtil;
import com.ibm.vida.rave.core.internal.selector.mirror.MirrorUtil;
import com.ibm.vida.rave.core.internal.selector.mirror.WrappedMirroredSceneNodeHelper;
import com.ibm.vida.rave.core.scene.SceneNode;
import java.util.ArrayList;

public class MirroredSceneNodeHelper {
    static void update(SceneNode node) {
        if (node == null) {
            return;
        }
        SceneNode group = MirrorUtil.getWrappingGroup(node);
        if (group != null) {
            double translateWidth = SceneNodeUtil.getOwnerBoundingClientRect((SceneNode)node).width;
            group.setAttribute("transform", "translate(" + translateWidth + ",0) scale(-1,1)");
        } else {
            switch (node.getDrawType()) {
                case 1003: 
                case 1007: {
                    WrappedMirroredSceneNodeHelper.update(node);
                    break;
                }
            }
        }
    }

    static void mirrorNode(SceneNode context) {
        SceneNode node = MirrorUtil.getExtendableNode(context);
        if (!MirrorUtil.isMirrored(node)) {
            node.setProperty("__rave-mirrored__", true);
            Configuration.INSTANCE.extend(node, null);
            context.setProperty("__rave-mirrored__", true);
        }
        MirrorUtil.setRawNode(node, true);
        ArrayEx<SceneNode> children = new ArrayEx<SceneNode>();
        for (SceneNode child : node.getChildNodes()) {
            children.add(child);
        }
        MirrorUtil.setRawNode(node, false);
        for (SceneNode child : children) {
            MirroredSceneNodeHelper.mirrorNode(child);
        }
        MirroredSceneNodeHelper.update(node);
    }

    static void unMirrorNode(SceneNode context) {
        SceneNode node = MirrorUtil.getExtendableNode(context);
        if (MirrorUtil.hasWrappingGroup(node)) {
            MirroredSceneNodeHelper._unmirrorOwnerNode(node);
        }
        node.setProperty("__rave-mirrored__", null);
        context.setProperty("__rave-mirrored__", null);
        MirrorUtil.setRawNode(node, true);
        ArrayList<SceneNode> children = new ArrayList<SceneNode>();
        for (SceneNode child : node.getChildNodes()) {
            children.add(child);
        }
        MirrorUtil.setRawNode(node, false);
        for (SceneNode child : children) {
            MirroredSceneNodeHelper.unMirrorNode(child);
        }
        MirroredSceneNodeHelper.update(node);
    }

    static void _unmirrorOwnerNode(SceneNode node) {
        SceneNode group = MirrorUtil.getWrappingGroup(node);
        if (group != null) {
            MirrorUtil.setRawNode(node, true);
            SceneNode groupNode = group;
            groupNode.setProperty("__rave-mirrored-group__", null);
            ArrayList<SceneNode> existingChildren = new ArrayList<SceneNode>();
            for (SceneNode child : groupNode.getChildNodes()) {
                existingChildren.add(child);
            }
            for (SceneNode child : existingChildren) {
                node.appendChild(child);
            }
            Rave.select(groupNode).remove();
            MirrorUtil.setRawNode(node, false);
        }
        node.setProperty("__rave-mirrored__", null);
        node.setProperty("__rave-group-node-property__", null);
    }

    public static void mirrorNode(SceneNode context, boolean mirror) {
        if (mirror) {
            if (MirrorUtil.isGroupOrOwnerNode(context) && !MirrorUtil.isMirrored(context)) {
                if (!MirrorUtil.hasWrappingGroup(context)) {
                    MirrorUtil.createWrappingGroup(context);
                }
                MirroredSceneNodeHelper.mirrorNode(context);
            }
        } else {
            MirroredSceneNodeHelper.unMirrorNode(context);
        }
    }
}

