/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.selector.mirror;

import com.ibm.vida.rave.core.Configuration;
import com.ibm.vida.rave.core.ExtensionFactory;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.selector.mirror.MirrorUtil;
import com.ibm.vida.rave.core.internal.selector.mirror.MirroredSceneNodeExtension;
import com.ibm.vida.rave.core.internal.selector.mirror.MirroredSceneNodeHelper;
import com.ibm.vida.rave.core.internal.util.QueryUtil;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.scene.SceneNodeExtensionFactory;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.Selector;

public class MirroredSelector
extends Selector {
    private static String MIRROR_FILTER = "rave-mirror-filter";
    private static final String EXTENDED_NAMESPACES_KEY = "EXTENDED_NAMESPACES_KEY";
    private static final ExtensionFactory<Selector> factory = new ExtensionFactory<Selector>(){

        @Override
        public MirroredSelector create() {
            return new MirroredSelector();
        }
    };
    private static final SceneNodeExtensionFactory mirroringExtensionsFactory = new SceneNodeExtensionFactory(){

        @Override
        public void extend(SceneNode node, SceneNode context) {
            MirroredSceneNodeExtension.extend(node);
        }
    };
    private static Configuration.FilterFunctionClass filterFunction = new Configuration.FilterFunctionClass(){

        @Override
        public SceneNode filter(SceneNode item, String query) {
            if (MirrorUtil.isGroupNode(item)) {
                if (query != null) {
                    return QueryUtil.getQueryEngine(item).querySelector(query, item);
                }
                return null;
            }
            return item;
        }
    };

    private static OMap<String, Boolean> getExtendedNamespaces() {
        OMap namespaces = (OMap)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENDED_NAMESPACES_KEY);
        if (namespaces == null) {
            namespaces = new OMap();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENDED_NAMESPACES_KEY, namespaces);
        }
        return namespaces;
    }

    @Override
    protected ExtensionFactory<Selector> getSelectorFactory() {
        return factory;
    }

    public MirroredSelector() {
        this.needsNodeExtension = true;
    }

    @Override
    public Selector mirror(final boolean mirror) {
        this.each(new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                MirroredSceneNodeHelper.mirrorNode(context, mirror);
            }
        });
        return this;
    }

    public MirroredSelector register(SceneNode node) {
        OMap<String, Boolean> extendedNamespaces;
        String uri = node.getNamespaceURI();
        if ("canvas".equals(node.getName().toLowerCase())) {
            uri = "canvas";
        }
        if (!(extendedNamespaces = MirroredSelector.getExtendedNamespaces()).containsKey(uri)) {
            Rave.configuration.addSceneNodeExtensionFactory(uri, mirroringExtensionsFactory, 0);
            Configuration.INSTANCE.registerFilter(MIRROR_FILTER, filterFunction);
            extendedNamespaces.put(uri, true);
        }
        return this;
    }
}

