/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.selector.mirror;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.internal.css.CSSTransformParser;
import com.ibm.vida.rave.core.internal.selector.mirror.MirrorUtil;
import com.ibm.vida.rave.core.internal.selector.mirror.MirroredSceneNodeUtils;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.transform.Matrix;
import com.ibm.vida.rave.core.transform.MatrixUtil;

public class WrappedMirroredSceneNodeHelper {
    @InlineStringConstant
    private static final String TRANSFORM = "transform";

    protected static void update(final SceneNode node) {
        MirroredSceneNodeUtils.wrapTimer(new TimerEvent(){

            @Override
            public boolean run(double elapsed) {
                MirrorUtil.setRawNode(node, true);
                String originalTransformAttribute = WrappedMirroredSceneNodeHelper.getOriginalTransformAttribute(node);
                if (originalTransformAttribute == null) {
                    originalTransformAttribute = WrappedMirroredSceneNodeHelper.storeOriginalTransformAttr(node);
                }
                if (originalTransformAttribute.equals("")) {
                    node.removeAttribute(WrappedMirroredSceneNodeHelper.TRANSFORM);
                } else {
                    node.setAttribute(WrappedMirroredSceneNodeHelper.TRANSFORM, originalTransformAttribute);
                }
                String originalStyleTransform = WrappedMirroredSceneNodeHelper.getOriginalStyleTransform(node);
                if (originalStyleTransform == null) {
                    originalStyleTransform = WrappedMirroredSceneNodeHelper.storeOriginalStyleTransform(node);
                }
                if (originalStyleTransform.equals("")) {
                    node.removeStyle(WrappedMirroredSceneNodeHelper.TRANSFORM);
                } else {
                    node.setStyle(WrappedMirroredSceneNodeHelper.TRANSFORM, originalStyleTransform, "");
                }
                if (MirrorUtil.isWrappableNode(node) && MirrorUtil.isMirrored(node)) {
                    try {
                        Matrix transformMatrix;
                        String transform;
                        RaveRect rect = node.getBBox();
                        RectStruct struct = new RectStruct(rect.x, rect.y, rect.width, rect.height);
                        double translateAmount = struct.width + 2.0 * struct.x;
                        Matrix ctm = CSSTransformParser.parse("matrix(1,0,0,1,0,0)");
                        Matrix transformStyle = null;
                        Matrix transformAttr = null;
                        Matrix computedStyleMatrix = CSSTransformParser.parse((String)node.getComputedStyle(WrappedMirroredSceneNodeHelper.TRANSFORM));
                        if (computedStyleMatrix != null) {
                            transformStyle = computedStyleMatrix;
                            node.removeStyle(WrappedMirroredSceneNodeHelper.TRANSFORM);
                        }
                        if ((transform = (String)node.getAttribute(WrappedMirroredSceneNodeHelper.TRANSFORM)) != null && (transformMatrix = CSSTransformParser.parse(transform)) != null) {
                            transformAttr = transformMatrix;
                            node.removeAttribute(WrappedMirroredSceneNodeHelper.TRANSFORM);
                        }
                        if (transformStyle != null) {
                            ctm = transformStyle;
                        } else if (transformAttr != null) {
                            ctm = transformAttr;
                        }
                        Matrix newCTM = ctm.translate(translateAmount, 0.0);
                        newCTM = newCTM.scaleNonUniform(-1.0, 1.0);
                        String newStyleAttr = MatrixUtil.matrixToString(newCTM);
                        node.setAttribute(WrappedMirroredSceneNodeHelper.TRANSFORM, newStyleAttr);
                    }
                    catch (Throwable rect) {}
                } else {
                    String transformAttr = WrappedMirroredSceneNodeHelper.getOriginalTransformAttribute(node);
                    if (transformAttr != null && transformAttr.length() > 0) {
                        node.setAttribute(WrappedMirroredSceneNodeHelper.TRANSFORM, transformAttr);
                    } else {
                        node.removeAttribute(WrappedMirroredSceneNodeHelper.TRANSFORM);
                    }
                    String transformStyle = WrappedMirroredSceneNodeHelper.getOriginalStyleTransform(node);
                    if (transformStyle != null && transformStyle.length() > 0) {
                        node.setStyle(WrappedMirroredSceneNodeHelper.TRANSFORM, transformStyle);
                    }
                }
                MirrorUtil.setRawNode(node, false);
                return true;
            }
        });
    }

    private static String storeOriginalStyleTransform(SceneNode node) {
        Object style = node.getStyle(TRANSFORM);
        String styleStr = style != null ? (String)style : "";
        node.setProperty("__rave-original-style__", styleStr);
        return styleStr;
    }

    private static String getOriginalStyleTransform(SceneNode node) {
        return (String)node.getProperty("__rave-original-style__");
    }

    private static String storeOriginalTransformAttr(SceneNode node) {
        Object style = node.getAttribute(TRANSFORM);
        String styleStr = style != null ? (String)style : "";
        node.setProperty("__rave-original-transform__", styleStr);
        return styleStr;
    }

    private static String getOriginalTransformAttribute(SceneNode node) {
        return (String)node.getProperty("__rave-original-transform__");
    }
}

