/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.transitions;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.ease.Easing;
import com.ibm.vida.rave.core.ease.EasingFunction;
import com.ibm.vida.rave.core.event.Dispatcher;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.transitions.PauseInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionTracker;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.transition.ITransitionInfo;
import com.ibm.vida.rave.core.transition.Transition;
import com.ibm.vida.rave.core.transition.Tween;
import java.util.ArrayList;
import java.util.List;

public final class TransitionInfo
implements ITransitionInfo {
    private double delay = 0.0;
    private double duration = 250.0;
    private EasingFunction ease = Easing.DEFAULT;
    private final OMap<String, ValueFunction<SceneNode, Tween<SceneNode>>> tween = new OMap();
    private Dispatcher<SceneNode> event;
    private double time = -1.0;
    private final int transitionId;
    private final SceneNode node;
    private Transition _transition;
    private int index;
    private int groupIndex;
    @SwiftWeak
    private final TransitionTracker tracker;
    private boolean scheduled;
    private PauseInfo pauseInfo;

    public TransitionInfo(TransitionTracker tracker, int id, SceneNode node) {
        this.tracker = tracker;
        this.transitionId = id;
        this.node = node;
        this.pauseInfo = new PauseInfo();
    }

    public int getTransitionId() {
        return this.transitionId;
    }

    public void setTransition(Transition trans) {
        this._transition = trans;
    }

    public Transition getTransition() {
        return this._transition;
    }

    public TransitionTracker getTracker() {
        return this.tracker;
    }

    public SceneNode getSceneNode() {
        return this.node;
    }

    public Dispatcher<SceneNode> getOrCreateDispatcher() {
        if (this.event == null) {
            this.event = Dispatcher.create("start", "end", "interrupt", "pause", "resume");
        }
        return this.event;
    }

    public Dispatcher<SceneNode> getDispatcher() {
        return this.event;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setDelay(double delay) {
        this.delay = delay;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setEase(EasingFunction ease) {
        this.ease = ease;
    }

    public EasingFunction getEase() {
        return this.ease;
    }

    public PauseInfo getPauseInfo() {
        return this.pauseInfo;
    }

    public void addTweenFactory(String key, ValueFunction<SceneNode, Tween<SceneNode>> factory) {
        this.tween.put(key, factory);
    }

    public void removeTweenFactory(String key) {
        this.tween.remove(key);
    }

    public ValueFunction<SceneNode, Tween<SceneNode>> getTweenFactory(String key) {
        return this.tween.get(key);
    }

    @Override
    public List<Tween<SceneNode>> getTweens() {
        SceneNode sceneNode = this.node;
        Object data = sceneNode.getData();
        int i = this.index;
        int gi = this.groupIndex;
        ArrayList<Tween<SceneNode>> tweens = new ArrayList<Tween<SceneNode>>();
        for (String key : this.tween.keySet()) {
            ValueFunction<SceneNode, Tween<SceneNode>> tf = this.tween.get(key);
            Tween<SceneNode> t = tf.getValue(sceneNode, data, i, gi);
            if (t == null) continue;
            tweens.add(t);
        }
        return tweens;
    }

    public double getStartTime() {
        return this.time;
    }

    public void setStartTime(double startTime) {
        this.time = startTime;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled() {
        this.scheduled = true;
    }
}

