/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.transitions;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.event.Dispatcher;
import com.ibm.vida.rave.core.internal.transitions.PauseInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionTracker;
import com.ibm.vida.rave.core.nativeImpl.timer.Timer;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.transition.Transition;

public final class TransitionUtil {
    @InlineStringConstant
    private static final String TRANSITION_PROPERTY = "__transition_";

    public static TransitionInfo getTransitionInfo(SceneNode node, String namespace, int id) {
        TransitionTracker tracker = TransitionUtil.getTransitionTracker(node, namespace);
        TransitionInfo info = (TransitionInfo)tracker.get(id);
        if (info == null) {
            ++tracker.count;
            info = new TransitionInfo(tracker, id, node);
            tracker.put(id, info);
        }
        return info;
    }

    public static TransitionTracker getTransitionTracker(SceneNode node, String namespace) {
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker == null) {
            tracker = new TransitionTracker();
            node.setProperty(namespace, tracker);
        }
        return tracker;
    }

    public static void disposeTransition(SceneNode node, String namespace) {
        node.removeProperty(namespace);
    }

    public static void interrupt(SceneNode node) {
        TransitionUtil.interruptNS(node, TransitionUtil.transitionNamespace(null));
    }

    public static void interruptNS(SceneNode node, String namespace) {
        TransitionInfo active;
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker != null && (active = (TransitionInfo)tracker.get((int)tracker.active)) != null) {
            if (--tracker.count > 0) {
                tracker.remove((int)tracker.active);
            } else {
                TransitionUtil.disposeTransition(node, namespace);
            }
            tracker.active += 0.5;
            if (active.getDispatcher() != null) {
                ((Dispatcher.DispatcherEvent)active.getDispatcher().get("interrupt")).fire(node, node.getData(), active.getIndex());
            }
        }
    }

    public static void pauseNS(SceneNode node, String namespace) {
        ArrayEx<Double> _delayedIds = new ArrayEx<Double>();
        PauseInfo pauseInfo = null;
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker != null) {
            for (Integer key : tracker.keySet()) {
                TransitionInfo info = (TransitionInfo)tracker.get(key);
                if (info != null) {
                    pauseInfo = info.getPauseInfo();
                }
                if (pauseInfo == null) continue;
                if (!pauseInfo.isRunning() && info.getDelay() > 0.0) {
                    _delayedIds.add(pauseInfo.getEventId());
                    continue;
                }
                pauseInfo.requestPause();
            }
            if (_delayedIds.size() > 0) {
                Timer.INSTANCE.pauseDelayedTasks(_delayedIds, true);
            }
        }
    }

    public static void resumeNS(SceneNode node, String namespace) {
        ArrayEx<Double> _delayedIds = new ArrayEx<Double>();
        PauseInfo pauseInfo = null;
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker != null) {
            for (Integer key : tracker.keySet()) {
                TransitionInfo info = (TransitionInfo)tracker.get(key);
                if (info != null) {
                    pauseInfo = info.getPauseInfo();
                }
                if (pauseInfo == null) continue;
                if (!pauseInfo.isRunning() && info.getDelay() > 0.0) {
                    _delayedIds.add(pauseInfo.getEventId());
                    continue;
                }
                pauseInfo.requestResume();
            }
            if (_delayedIds.size() > 0) {
                Timer.INSTANCE.pauseDelayedTasks(_delayedIds, false);
            }
        }
    }

    public static void endNS(SceneNode node, String namespace) {
        ArrayEx<Double> _delayedIds = new ArrayEx<Double>();
        PauseInfo pauseInfo = null;
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker != null) {
            for (Integer key : tracker.keySet()) {
                TransitionInfo info = (TransitionInfo)tracker.get(key);
                Transition transition = info.getTransition();
                if (transition == null) continue;
                pauseInfo = info.getPauseInfo();
                if (!pauseInfo.isRunning()) {
                    _delayedIds.add(pauseInfo.getEventId());
                    transition.duration(0).delay(0);
                    continue;
                }
                pauseInfo.pause(transition.duration() + transition.delay() + 1.0);
                pauseInfo.requestResume();
            }
            if (_delayedIds.size() > 0) {
                Timer.INSTANCE.triggerDelayedTasks(_delayedIds);
            }
        }
    }

    public static String transitionNamespace(String name) {
        return name == null ? "__transition__" : TRANSITION_PROPERTY + name + "__";
    }
}

