/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.transitions;

import com.ibm.vida.rave.core.context.RaveOperationalMode;
import com.ibm.vida.rave.core.ease.EasingFunction;
import com.ibm.vida.rave.core.event.Dispatcher;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.transitions.PauseInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionTracker;
import com.ibm.vida.rave.core.internal.transitions.TransitionUtil;
import com.ibm.vida.rave.core.nativeImpl.timer.Timer;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.SelectorGroup;
import com.ibm.vida.rave.core.transition.Transition;
import com.ibm.vida.rave.core.transition.Tween;
import java.util.List;

public final class Tweener {
    public static void schedule(final Transition transition) {
        Timer.INSTANCE.addEvent(new TimerEvent(){

            @Override
            public boolean run(double elapsed) {
                Tweener.scheduleTransition(transition);
                return true;
            }
        }, 0.0, Lang.now());
    }

    private static void scheduleTransition(Transition transition) {
        int transitionId = transition.getId();
        String namespace = transition.getNamespace();
        int m = transition.length();
        for (int j = 0; j < m; ++j) {
            SelectorGroup group = (SelectorGroup)transition.get(j);
            int n = group.size();
            for (int i = 0; i < n; ++i) {
                TransitionInfo info;
                SceneNode node = (SceneNode)group.get(i);
                if (node == null || (info = TransitionUtil.getTransitionInfo(node, namespace, transitionId)).isScheduled()) continue;
                info.setScheduled();
                TransitionTracker tracker = info.getTracker();
                double infoStartTime = info.getStartTime();
                Tweener.doSchedule(info, tracker, namespace, transitionId, infoStartTime);
            }
        }
    }

    private static void doSchedule(final TransitionInfo info, final TransitionTracker tracker, final String namespace, final int id, double infoStartTime) {
        double startTime;
        SceneNode node = info.getSceneNode();
        double d = startTime = infoStartTime > 0.0 ? infoStartTime : Timer.INSTANCE.currentTime();
        if (infoStartTime <= 0.0) {
            info.setStartTime(startTime);
        }
        if (tracker.active > (double)id) {
            Transition trans;
            TransitionInfo deadTransition = (TransitionInfo)tracker.get(id);
            Tweener.stop(tracker, node, namespace, id);
            if (deadTransition != null && (trans = deadTransition.getTransition()) != null) {
                trans.nodeTransitionComplete();
            }
        } else {
            final TimerEvent[] tick = new TimerEvent[1];
            TimerEvent start = new TimerEvent(){

                @Override
                public boolean run(double startElapsed) {
                    if (tick[0] == null) {
                        tick[0] = Tweener.startAndCreateTick(info, tracker, namespace, id, startTime, startElapsed);
                        return tick[0] == null;
                    }
                    return tick[0].run(startElapsed);
                }
            };
            double eventId = Timer.INSTANCE.newEventId();
            info.getPauseInfo().storeEventId(eventId);
            Timer.INSTANCE.addEvent(start, 0.0, startTime + info.getDelay(), eventId);
        }
    }

    private static TimerEvent startAndCreateTick(final TransitionInfo info, final TransitionTracker tracker, final String namespace, final int id, double startTime, final double startElapsed) {
        final SceneNode node = info.getSceneNode();
        final int index = info.getIndex();
        final int groupIndex = info.getGroupIndex();
        final PauseInfo pauseInfo = info.getPauseInfo();
        if (tracker.active > (double)id) {
            Transition trans;
            TransitionInfo deadTransition = (TransitionInfo)tracker.get(id);
            Tweener.stop(tracker, node, namespace, id);
            if (deadTransition != null && (trans = deadTransition.getTransition()) != null) {
                trans.nodeTransitionComplete();
            }
            return null;
        }
        TransitionInfo active = (TransitionInfo)tracker.get((int)tracker.active);
        if (active != null) {
            Transition trans;
            --tracker.count;
            tracker.remove((int)tracker.active);
            if (active.getDispatcher() != null) {
                ((Dispatcher.DispatcherEvent)active.getDispatcher().get("interrupt")).fire(node, node.getData(), active.getIndex());
            }
            if ((trans = active.getTransition()) != null) {
                trans.nodeTransitionComplete();
            }
        }
        tracker.active = id;
        if (info.getDispatcher() != null) {
            ((Dispatcher.DispatcherEvent)info.getDispatcher().get("start")).fire(node, node.getData(), index, groupIndex);
        }
        pauseInfo.setRunning(true);
        final List<Tween<SceneNode>> tweens = info.getTweens();
        final EasingFunction ease = info.getEase();
        final double duration = info.getDuration();
        final TimerEvent tick = new TimerEvent(){

            @Override
            public boolean run(double elapsed) {
                if (tracker.active != (double)id) {
                    return true;
                }
                if (pauseInfo.isPaused()) {
                    if (pauseInfo.isResumeRequested()) {
                        pauseInfo.resume(elapsed);
                        if (info.getDispatcher() != null) {
                            ((Dispatcher.DispatcherEvent)info.getDispatcher().get("resume")).fire(node, node.getData(), index, groupIndex);
                        }
                    } else {
                        return false;
                    }
                }
                double computedElapsed = elapsed - pauseInfo.getResumedTime() + pauseInfo.getEllapsedTime();
                double t = RaveOperationalMode.MODE == 1 ? 1.0 : computedElapsed / duration;
                double v = ease == null ? t : ease.ease(t);
                for (Tween tween : tweens) {
                    tween.tween(node, v, true);
                }
                if (t >= 1.0) {
                    Transition trans;
                    if (info.getDispatcher() != null) {
                        ((Dispatcher.DispatcherEvent)info.getDispatcher().get("end")).fire(node, node.getData(), index, groupIndex);
                    }
                    if ((trans = info.getTransition()) != null) {
                        trans.nodeTransitionComplete();
                    }
                    return Tweener.stop(tracker, node, namespace, id);
                }
                if (pauseInfo.isPauseRequested()) {
                    pauseInfo.pause(computedElapsed);
                    if (info.getDispatcher() != null) {
                        ((Dispatcher.DispatcherEvent)info.getDispatcher().get("pause")).fire(node, node.getData(), index, groupIndex);
                    }
                }
                return false;
            }
        };
        Timer.INSTANCE.addEvent(new TimerEvent(){

            @Override
            public boolean run(double elapsed) {
                tick.run(startElapsed);
                return true;
            }
        }, 0.0, startTime);
        if (RaveOperationalMode.MODE == 1) {
            return null;
        }
        return startElapsed / duration < 1.0 ? tick : null;
    }

    private static boolean stop(TransitionTracker tracker, SceneNode node, String namespace, int id) {
        if (--tracker.count > 0) {
            tracker.remove(id);
        } else {
            TransitionUtil.disposeTransition(node, namespace);
        }
        return true;
    }
}

