/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.util;

import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.util.QName;

public final class NamespaceUtil {
    private static final String NAMESPACES_KEY = "NAMESPACES_KEY";

    public static OMap<String, String> getNamespaces() {
        OMap<String, String> namespaces = (OMap<String, String>)RaveContextManager.INSTANCE.getRaveContext().getData(NAMESPACES_KEY);
        if (namespaces == null) {
            namespaces = NamespaceUtil.initialize_NAMESPACES();
            RaveContextManager.INSTANCE.getRaveContext().putData(NAMESPACES_KEY, namespaces);
        }
        return namespaces;
    }

    private static final OMap<String, String> initialize_NAMESPACES() {
        OMap<String, String> namespaces = new OMap<String, String>();
        namespaces.put("svg", "http://www.w3.org/2000/svg");
        namespaces.put("xhtml", "http://www.w3.org/1999/xhtml");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        return namespaces;
    }

    public static QName getQName(String name) {
        String _name = name;
        int idx = _name.indexOf(":");
        String prefix = _name;
        if (idx >= 0) {
            prefix = _name.substring(0, idx);
            _name = _name.substring(idx + 1);
        }
        QName qname = new QName();
        qname.local = _name;
        OMap<String, String> namespaces = NamespaceUtil.getNamespaces();
        if (namespaces.containsKey(prefix)) {
            qname.space = namespaces.get(prefix);
        }
        return qname;
    }
}

