/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.interpolate;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.color.Colors;
import com.ibm.vida.rave.core.color.HCL;
import com.ibm.vida.rave.core.color.HSL;
import com.ibm.vida.rave.core.color.LAB;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.interpolate.Interpolator;
import com.ibm.vida.rave.core.interpolate.InterpolatorFactory;

public final class ColorInterpolation {
    public static final InterpolatorFactory<Object> HSLINSTANCE = new HSLInterpolation();
    public static final InterpolatorFactory<Object> HCLINSTANCE = new HCLInterpolation();
    public static final InterpolatorFactory<Object> LABINSTANCE = new LABInterpolation();
    public static final InterpolatorFactory<Object> RGBINSTANCE = new RGBInterpolation();

    private static class RGBInterpolation
    implements InterpolatorFactory<Object> {
        private RGBInterpolation() {
        }

        @Override
        @SwiftMethodOverload(overloads={"String"})
        public Interpolator<String> create(Object a, Object b) {
            RGB aColor = Rave.rgb(a);
            RGB bColor = Rave.rgb(b);
            final int ar = aColor.getR();
            final int ag = aColor.getG();
            final int ab = aColor.getB();
            final int br = bColor.getR() - ar;
            final int bg = bColor.getG() - ag;
            final int bb = bColor.getB() - ab;
            final double a_alpha = aColor.getA();
            final double b_alpha = bColor.getA();
            return new Interpolator<String>(){

                @Override
                public String interpolate(double t) {
                    int r = (int)Math.round((double)ar + (double)br * t);
                    int g = (int)Math.round((double)ag + (double)bg * t);
                    int b = (int)Math.round((double)ab + (double)bb * t);
                    double a = a_alpha + (b_alpha - a_alpha) * t;
                    return Colors.newRGBA(r, g, b, a).toString();
                }
            };
        }
    }

    private static class LABInterpolation
    implements InterpolatorFactory<Object> {
        private LABInterpolation() {
        }

        @Override
        @SwiftMethodOverload(overloads={"String"})
        public Interpolator<String> create(Object a, Object b) {
            LAB aColor = Rave.lab(a);
            LAB bColor = Rave.lab(b);
            final double al = aColor.getL();
            final double aa = aColor.getA();
            final double ab = aColor.getB();
            final double bl = bColor.getL() - al;
            final double ba = bColor.getA() - aa;
            final double bb = bColor.getB() - ab;
            return new Interpolator<String>(){

                @Override
                public String interpolate(double t) {
                    return Colors.lab_rgb(al + bl * t, aa + ba * t, ab + bb * t).toString();
                }
            };
        }
    }

    private static class HCLInterpolation
    implements InterpolatorFactory<Object> {
        private HCLInterpolation() {
        }

        @Override
        @SwiftMethodOverload(overloads={"String"})
        public Interpolator<String> create(Object a, Object b) {
            HCL aColor = Rave.hcl(a);
            HCL bColor = Rave.hcl(b);
            double ah = aColor.getH();
            double ac = aColor.getC();
            double al = aColor.getL();
            double bh = bColor.getH() - ah;
            double bc = bColor.getC() - ac;
            double bl = bColor.getL() - al;
            if (Double.isNaN(bc)) {
                bc = 0.0;
                double d = ac = Double.isNaN(ac) ? bColor.getC() : ac;
            }
            if (Double.isNaN(bh)) {
                bh = 0.0;
                ah = Double.isNaN(ah) ? bColor.getH() : ah;
            } else if (bh > 180.0) {
                bh -= 360.0;
            } else if (bh < -180.0) {
                bh += 360.0;
            }
            final double ahf = ah;
            final double bhf = bh;
            final double acf = ac;
            final double bcf = bc;
            final double alf = al;
            final double blf = bl;
            return new Interpolator<String>(){

                @Override
                public String interpolate(double t) {
                    return Colors.hcl_lab(ahf + bhf * t, acf + bcf * t, alf + blf * t).toString();
                }
            };
        }
    }

    private static class HSLInterpolation
    implements InterpolatorFactory<Object> {
        private HSLInterpolation() {
        }

        @Override
        @SwiftMethodOverload(overloads={"String"})
        public Interpolator<String> create(Object a, Object b) {
            HSL aColor = Rave.hsl(a);
            HSL bColor = Rave.hsl(b);
            double ah = aColor.getH();
            double as = aColor.getS();
            double al = aColor.getL();
            double bh = bColor.getH() - ah;
            double bs = bColor.getS() - as;
            double bl = bColor.getL() - al;
            if (Double.isNaN(bs)) {
                bs = 0.0;
                double d = as = Double.isNaN(as) ? bColor.getS() : as;
            }
            if (Double.isNaN(bh)) {
                bh = 0.0;
                ah = Double.isNaN(ah) ? bColor.getH() : ah;
            } else if (bh > 180.0) {
                bh -= 360.0;
            } else if (bh < -180.0) {
                bh += 360.0;
            }
            final double ahf = ah;
            final double bhf = bh;
            final double asf = as;
            final double bsf = bs;
            final double alf = al;
            final double blf = bl;
            final double a_alpha = aColor.getA();
            final double b_alpha = bColor.getA();
            return new Interpolator<String>(){

                @Override
                public String interpolate(double t) {
                    double a = a_alpha + (b_alpha - a_alpha) * t;
                    return Colors.hsl_rgb(ahf + bhf * t, asf + bsf * t, alf + blf * t, a).toString();
                }
            };
        }
    }
}

