/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.interpolate;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.nativeImpl.RegExp;
import com.ibm.vida.rave.core.interpolate.Interpolator;
import com.ibm.vida.rave.core.interpolate.InterpolatorFactory;
import com.ibm.vida.rave.core.interpolate.NumberInterpolation;
import java.util.ArrayList;

public final class StringInterpolation
implements InterpolatorFactory<Object> {
    public static final StringInterpolation INSTANCE = new StringInterpolation();
    @InlineStringConstant
    private static final String STRING_INTERPOLATION_REG_EXP_KEY = "STRING_INTERPOLATION_REG_EXP_KEY";

    private static StringInterpolationRegExps getStringInterpolationRegExps() {
        StringInterpolationRegExps stringInterpolationRegExps = (StringInterpolationRegExps)RaveContextManager.INSTANCE.getRaveContext().getData(STRING_INTERPOLATION_REG_EXP_KEY);
        if (stringInterpolationRegExps == null) {
            stringInterpolationRegExps = new StringInterpolationRegExps();
            RaveContextManager.INSTANCE.getRaveContext().putData(STRING_INTERPOLATION_REG_EXP_KEY, stringInterpolationRegExps);
        }
        return stringInterpolationRegExps;
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public final Interpolator<String> create(Object a, Object b) {
        Object tmp;
        String bs;
        RegExp.RegExpResult bm;
        RegExp.RegExpResult am;
        StringInterpolationRegExps stringInterpolationRegExps = StringInterpolation.getStringInterpolationRegExps();
        RegExp are = stringInterpolationRegExps.aRegExp;
        RegExp bre = stringInterpolationRegExps.bRegExp;
        bre.lastIndex = 0;
        are.lastIndex = 0;
        String ax = a + "";
        String bx = b + "";
        final ArrayList<String> ls = new ArrayList<String>();
        final ArrayList<IndexInterpolator> lq = new ArrayList<IndexInterpolator>();
        int bi = 0;
        int i = -1;
        while ((am = are.exec(ax)) != null && (bm = bre.exec(bx)) != null) {
            int bsi = bm.index;
            if (bsi > bi) {
                bs = bx.substring(bi, bsi);
                Object v0 = tmp = i >= 0 && i < ls.size() ? ls.get(i) : null;
                if (tmp != null) {
                    ls.set(i, tmp + bs);
                } else {
                    ls.add(bs);
                    ++i;
                }
            }
            if (((String)am.get(0)).equals(bm.get(0))) {
                Object v1 = tmp = i > 0 && i < ls.size() ? ls.get(i) : null;
                if (tmp != null) {
                    ls.set(i, tmp + (String)bm.get(0));
                } else {
                    ls.add((String)bm.get(0));
                    ++i;
                }
            } else {
                ls.add(null);
                lq.add(new IndexInterpolator(++i, NumberInterpolation.INSTANCE.create(am.get(0), bm.get(0))));
            }
            bi = bre.lastIndex;
        }
        if (bi < bx.length()) {
            bs = bx.substring(bi);
            Object v2 = tmp = i > 0 && i < ls.size() ? ls.get(i) : null;
            if (tmp != null) {
                ls.set(i, tmp + bs);
            } else {
                ls.add(bs);
                ++i;
            }
        }
        if (ls.size() < 2) {
            if (lq.size() > 0) {
                final Interpolator<?> lq0Interpolator = ((IndexInterpolator)lq.get((int)0)).x;
                return new Interpolator<String>(){

                    @Override
                    public String interpolate(double t) {
                        return lq0Interpolator.interpolate(t) + "";
                    }
                };
            }
            final String fb = bx;
            return new Interpolator<String>(){

                @Override
                public String interpolate(double t) {
                    return fb;
                }
            };
        }
        final int lqSize = lq.size();
        return new Interpolator<String>(){

            @Override
            public String interpolate(double t) {
                for (int i = 0; i < lqSize; ++i) {
                    IndexInterpolator o = (IndexInterpolator)lq.get(i);
                    ls.set(o.i, o.x.interpolate(t));
                }
                return Lang.join(ls, "");
            }
        };
    }

    private static class IndexInterpolator {
        int i;
        Interpolator<?> x;

        IndexInterpolator(int i, Interpolator<?> interpolator) {
            this.i = i;
            this.x = interpolator;
        }
    }

    private static class StringInterpolationRegExps {
        final RegExp aRegExp = new RegExp("[-+]?(?:\\d+\\.?\\d*|\\.?\\d+)(?:[eE][-+]?\\d+)?", "g");
        final RegExp bRegExp;

        private StringInterpolationRegExps() {
            this.bRegExp = new RegExp(this.aRegExp.source, "g");
        }
    }
}

