/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.interpolate;

import com.ibm.vida.rave.core.interpolate.Interpolator;
import com.ibm.vida.rave.core.interpolate.InterpolatorFactory;
import com.ibm.vida.rave.core.interpolate.NumberInterpolation;
import com.ibm.vida.rave.core.transform.Transform;
import com.ibm.vida.rave.core.transform.TransformParser;
import java.util.ArrayList;

public class TransformInterpolation
implements InterpolatorFactory<String> {
    public static final TransformInterpolation INSTANCE = new TransformInterpolation();

    private TransformInterpolation() {
    }

    @Override
    public Interpolator<String> create(String a, String b) {
        int n;
        InterpolatedValue InterpolatedValue2;
        Interpolator<Number> x;
        InterpolatedValue InterpolatedValue1;
        Interpolator<Number> x1;
        InterpolatedValue InterpolatedValue0;
        ArrayList<String> s = new ArrayList<String>();
        ArrayList<InterpolatedValue> q = new ArrayList<InterpolatedValue>();
        Transform aTransform = TransformParser.create(a);
        final Transform bTransform = TransformParser.create(b);
        double[] ta = aTransform.translate;
        double[] tb = bTransform.translate;
        double ra = aTransform.rotate;
        double rb = bTransform.rotate;
        double wa = aTransform.skew;
        double wb = bTransform.skew;
        double[] ka = aTransform.scale;
        double[] kb = bTransform.scale;
        if (ta[0] != tb[0] || ta[1] != tb[1]) {
            s.add("translate(");
            s.add(null);
            s.add(",");
            s.add(null);
            s.add(")");
            Interpolator<Number> x0 = NumberInterpolation.INSTANCE.create((Object)ta[0], (Object)tb[0]);
            InterpolatedValue0 = new InterpolatedValue(1, x0);
            q.add(InterpolatedValue0);
            x1 = NumberInterpolation.INSTANCE.create((Object)ta[1], (Object)tb[1]);
            InterpolatedValue1 = new InterpolatedValue(3, x1);
            q.add(InterpolatedValue1);
        } else if (tb[0] != 0.0 || tb[1] != 0.0) {
            s.add("translate(" + tb[0] + "," + tb[1] + ")");
        } else {
            s.add("");
        }
        if (ra != rb) {
            if (ra - rb > 180.0) {
                rb += 360.0;
            } else if (rb - ra > 180.0) {
                ra += 360.0;
            }
            s.add("rotate(");
            s.add(null);
            s.add(")");
            int i = s.size() - 2;
            x = NumberInterpolation.INSTANCE.create((Object)ra, (Object)rb);
            InterpolatedValue2 = new InterpolatedValue(i, x);
            q.add(InterpolatedValue2);
        } else if (rb != 0.0) {
            s.add("rotate(" + rb + ")");
        }
        if (wa != wb) {
            s.add("skewX(");
            s.add(null);
            s.add(")");
            int i = s.size() - 2;
            x = NumberInterpolation.INSTANCE.create((Object)wa, (Object)wb);
            InterpolatedValue2 = new InterpolatedValue(i, x);
            q.add(InterpolatedValue2);
        } else if (wb != 0.0) {
            s.add("skewX(" + wb + ")");
        }
        if (ka[0] != kb[0] || ka[1] != kb[1]) {
            s.add("scale(");
            s.add(null);
            s.add(",");
            s.add(null);
            s.add(")");
            n = s.size();
            Interpolator<Number> x0 = NumberInterpolation.INSTANCE.create((Object)ka[0], (Object)kb[0]);
            InterpolatedValue0 = new InterpolatedValue(n - 4, x0);
            q.add(InterpolatedValue0);
            x1 = NumberInterpolation.INSTANCE.create((Object)ka[1], (Object)kb[1]);
            InterpolatedValue1 = new InterpolatedValue(n - 2, x1);
            q.add(InterpolatedValue1);
        } else if (kb[0] != 1.0 || kb[1] != 1.0) {
            s.add("scale(" + kb[0] + "," + kb[1] + ")");
        }
        final int nFinal = n = q.size();
        final ArrayList<String> sFinal = s;
        final ArrayList<InterpolatedValue> qFinal = q;
        return new Interpolator<String>(){

            @Override
            public String interpolate(double t) {
                if (t == 1.0) {
                    return bTransform.toString();
                }
                for (int i = 0; i < nFinal; ++i) {
                    InterpolatedValue o = (InterpolatedValue)qFinal.get(i);
                    sFinal.set(o.i, o.x.interpolate(t).toString());
                }
                String transformString = "";
                for (String tS : sFinal) {
                    transformString = transformString + tS;
                }
                return transformString;
            }
        };
    }

    private class InterpolatedValue {
        int i;
        Interpolator<Number> x;

        InterpolatedValue(int i, Interpolator<Number> x) {
            this.i = i;
            this.x = x;
        }
    }
}

