/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.interpolate;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.geom.Point3;
import com.ibm.vida.rave.core.internal.math.Trigonometry;
import com.ibm.vida.rave.core.internal.util.MathUtil;
import com.ibm.vida.rave.core.interpolate.Interpolator;
import com.ibm.vida.rave.core.interpolate.InterpolatorFactory;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class ZoomInterpolation
implements InterpolatorFactory<Point3> {
    public static final ZoomInterpolation INSTANCE = new ZoomInterpolation();
    private static final double p = MathUtil.SQRT2;
    private static final double p2 = 2.0;
    private static final double p4 = 4.0;

    public final ZoomInterpolator create(Point3 p0, Point3 p1) {
        final double ux0 = p0.getX();
        final double uy0 = p0.getY();
        final double w0 = p0.getZ();
        double ux1 = p1.getX();
        double uy1 = p1.getY();
        double w1 = p1.getZ();
        final double dx = ux1 - ux0;
        final double dy = uy1 - uy0;
        double d2 = dx * dx + dy * dy;
        final double d1 = Math.sqrt(d2);
        double b0 = (w1 * w1 - w0 * w0 + 4.0 * d2) / (2.0 * w0 * 2.0 * d1);
        double b1 = (w1 * w1 - w0 * w0 - 4.0 * d2) / (2.0 * w1 * 2.0 * d1);
        final double r0 = Math.log(Math.sqrt(b0 * b0 + 1.0) - b0);
        double r1 = Math.log(Math.sqrt(b1 * b1 + 1.0) - b1);
        final double dr = r1 - r0;
        final double S = (ObjectConverter.toBoolean(dr) ? dr : Math.log(w1 / w0)) / p;
        ZoomInterpolator interpolate = new ZoomInterpolator(){

            @Override
            public Point3 interpolate(double t) {
                Point3 point;
                double s = t * S;
                if (ObjectConverter.toBoolean(dr)) {
                    double coshr0 = Trigonometry.cosh(r0);
                    double u = w0 / (2.0 * d1) * (coshr0 * Trigonometry.tanh(p * s + r0) - Trigonometry.sinh(r0));
                    point = new Point3(ux0 + u * dx, uy0 + u * dy, w0 * coshr0 / Trigonometry.cosh(p * s + r0));
                } else {
                    point = new Point3(ux0 + t * dx, uy0 + t * dy, w0 * Math.exp(p * s));
                }
                return point;
            }
        };
        interpolate.duration = S * 1000.0;
        return interpolate;
    }

    @FunctionClass(value="interpolate", force=true)
    public static abstract class ZoomInterpolator
    implements Interpolator<Point3> {
        public double duration;

        @Override
        public abstract Point3 interpolate(double var1);
    }
}

