/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.layout.PackNode;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyBase;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public abstract class AbstractPackLayout<S extends AbstractPackLayout<S>>
extends HierarchyBase<PackNode, S> {
    protected double paddingVal = 0.0;
    protected double[] sizeVal = new double[]{1.0, 1.0};
    protected Object radiusVal = null;
    protected SingleValueFunction<Object, Object> radiusFn = null;

    public double[] size() {
        return this.sizeVal;
    }

    public S size(double[] newSize) {
        this.sizeVal = newSize;
        return (S)this;
    }

    public double padding() {
        return this.paddingVal;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public S padding(Object newVal) {
        this.paddingVal = ObjectConverter.toDouble(newVal);
        return (S)this;
    }

    public Object radius() {
        if (this.radiusFn == null) {
            return this.radiusVal;
        }
        return this.radiusFn;
    }

    public S radius(SingleValueFunction<Object, Object> newVal) {
        this.radiusFn = newVal;
        this.radiusVal = null;
        return (S)this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public S radius(Object newVal) {
        if (newVal instanceof SingleValueFunction) {
            this.radiusFn = (SingleValueFunction)newVal;
            this.radiusVal = null;
        } else {
            this.radiusFn = null;
            this.radiusVal = newVal;
        }
        return (S)this;
    }

    protected static class ConstantSingleValueFunction
    implements SingleValueFunction<Object, Object> {
        private final double realdata;

        public ConstantSingleValueFunction(Object constantData) {
            this.realdata = ObjectConverter.toDouble(constantData);
        }

        @Override
        @SwiftMethodOverload(skip=true)
        public Object getValue(Object data) {
            return this.realdata;
        }
    }
}

