/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.layout.AbstractPackLayout;
import com.ibm.vida.rave.core.layout.PackNode;
import com.ibm.vida.rave.core.layout.XYMin_Max;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyUtil;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.util.Comparator;

public class PackLayout
extends AbstractPackLayout<PackLayout> {
    private static SingleValueFunction<Object, Object> SQRT_FN = new SingleValueFunction<Object, Object>(){

        @Override
        public Object getValue(Object data) {
            return Math.sqrt(ObjectConverter.toDouble(data));
        }
    };
    private static Comparator<PackNode> PACK_SORT_FN = new Comparator<PackNode>(){

        @Override
        public int compare(PackNode a, PackNode b) {
            double val = a.value - b.value;
            return val == 0.0 ? 0 : (val > 0.0 ? 1 : -1);
        }
    };
    private static ArrayEx.ArrayValueFunction<PackNode, Object> layout_packLink = new ArrayEx.ArrayValueFunction<PackNode, Object>(){

        @Override
        public Object getValue(PackNode node, int index, ArrayEx<PackNode> array) {
            node._pack_next = node._pack_prev = node;
            return node;
        }
    };
    private static ArrayEx.ArrayValueFunction<PackNode, Object> layout_packUnlink = new ArrayEx.ArrayValueFunction<PackNode, Object>(){

        @Override
        public Object getValue(PackNode node, int index, ArrayEx<PackNode> array) {
            node._pack_next = null;
            node._pack_prev = null;
            return node;
        }
    };
    private static HierarchyUtil.Visitor<PackNode> layout_packSiblings = new HierarchyUtil.Visitor<PackNode>(){

        @Override
        public void visit(PackNode node) {
            PackNode c;
            ArrayEx nodes = node.children;
            if (nodes == null || nodes.length() == 0) {
                return;
            }
            int n = nodes.length();
            XYMin_Max minMax = new XYMin_Max();
            PackNode k = null;
            nodes.forEach(layout_packLink);
            PackNode a = (PackNode)nodes.get(0);
            a.x = -a.r;
            a.y = 0.0;
            minMax.bound(a);
            if (n > 1) {
                PackNode b = (PackNode)nodes.get(1);
                b.x = b.r;
                b.y = 0.0;
                minMax.bound(b);
                if (n > 2) {
                    c = (PackNode)nodes.get(2);
                    PackLayout.layout_packPlace(a, b, c);
                    minMax.bound(c);
                    PackLayout.d3_layout_packInsert(a, c);
                    a._pack_prev = c;
                    PackLayout.d3_layout_packInsert(c, b);
                    b = a._pack_next;
                    for (int i = 3; i < n; ++i) {
                        c = (PackNode)nodes.get(i);
                        PackLayout.layout_packPlace(a, b, c);
                        double isect = 0.0;
                        double s1 = 1.0;
                        double s2 = 1.0;
                        PackNode j = b._pack_next;
                        while (j != b) {
                            if (PackLayout.d3_layout_packIntersects(j, c)) {
                                isect = 1.0;
                                break;
                            }
                            j = j._pack_next;
                            s1 += 1.0;
                        }
                        if (isect == 1.0) {
                            k = a._pack_prev;
                            while (k != j._pack_prev && !PackLayout.d3_layout_packIntersects(k, c)) {
                                k = k._pack_prev;
                                s2 += 1.0;
                            }
                        }
                        if (ObjectConverter.toBoolean(isect)) {
                            if (s1 < s2 || s1 == s2 && b.r < a.r) {
                                b = j;
                                PackLayout.d3_layout_packSplice(a, b);
                            } else {
                                a = k;
                                PackLayout.d3_layout_packSplice(a, b);
                            }
                            --i;
                            continue;
                        }
                        PackLayout.d3_layout_packInsert(a, c);
                        b = c;
                        minMax.bound(c);
                    }
                }
            }
            double cx = (minMax.xMin + minMax.xMax) / 2.0;
            double cy = (minMax.yMin + minMax.yMax) / 2.0;
            double cr = 0.0;
            for (int i = 0; i < n; ++i) {
                c = (PackNode)nodes.get(i);
                c.x -= cx;
                c.y -= cy;
                cr = Math.max(cr, c.r + Math.sqrt(c.x * c.x + c.y * c.y));
            }
            node.r = cr;
            nodes.forEach(layout_packUnlink);
        }
    };

    public PackLayout() {
        this.sort(PACK_SORT_FN);
    }

    @Override
    public ArrayEx<PackNode> create(PackNode d) {
        ArrayEx<PackNode> nodes = super.create(d);
        PackNode root = (PackNode)nodes.get(0);
        double w = this.sizeVal[0];
        double h = this.sizeVal[1];
        if (w == 0.0 || h == 0.0) {
            HierarchyUtil.visitAfter(root, new HierarchyUtil.Visitor<PackNode>(){

                @Override
                public void visit(PackNode node) {
                    node.r = 0.0;
                    node.x = 0.0;
                    node.y = 0.0;
                }
            });
            return nodes;
        }
        final SingleValueFunction<Object, Object> localR = this.radiusFn == null && this.radiusVal == null ? SQRT_FN : (this.radiusFn == null ? new AbstractPackLayout.ConstantSingleValueFunction(this.radiusVal) : this.radiusFn);
        root.y = 0.0;
        root.x = 0.0;
        HierarchyUtil.visitAfter(root, new HierarchyUtil.Visitor<PackNode>(){

            @Override
            public void visit(PackNode node) {
                node.r = ObjectConverter.toDouble(localR.getValue(node.value));
            }
        });
        HierarchyUtil.visitAfter(root, layout_packSiblings);
        if (ObjectConverter.toBoolean(this.paddingVal)) {
            final double dr = this.paddingVal * (this.radiusFn != null || ObjectConverter.toBoolean(this.radiusVal) ? 1.0 : Math.max(2.0 * root.r / w, 2.0 * root.r / h)) / 2.0;
            HierarchyUtil.visitAfter(root, new HierarchyUtil.Visitor<PackNode>(){

                @Override
                public void visit(PackNode node) {
                    node.r += dr;
                }
            });
            HierarchyUtil.visitAfter(root, layout_packSiblings);
            HierarchyUtil.visitAfter(root, new HierarchyUtil.Visitor<PackNode>(){

                @Override
                public void visit(PackNode node) {
                    node.r -= dr;
                }
            });
        }
        this.layout_packTransform(root, w / 2.0, h / 2.0, this.radiusFn != null || ObjectConverter.toBoolean(this.radiusVal) ? 1.0 : 1.0 / Math.max(2.0 * root.r / w, 2.0 * root.r / h));
        return nodes;
    }

    private static void d3_layout_packInsert(PackNode a, PackNode b) {
        PackNode c = a._pack_next;
        a._pack_next = b;
        b._pack_prev = a;
        b._pack_next = c;
        c._pack_prev = b;
    }

    private static void d3_layout_packSplice(PackNode a, PackNode b) {
        a._pack_next = b;
        b._pack_prev = a;
    }

    private static boolean d3_layout_packIntersects(PackNode a, PackNode b) {
        double dr = a.r + b.r;
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        return 0.999 * dr * dr > dx * dx + dy * dy;
    }

    protected void layout_packTransform(PackNode node, double x, double y, double k) {
        double _x = x;
        double _y = y;
        ArrayEx children = node.children;
        node.x = _x += k * node.x;
        node.y = _y += k * node.y;
        node.r *= k;
        if (children != null) {
            int i = -1;
            int n = children.length();
            while (++i < n) {
                this.layout_packTransform((PackNode)children.get(i), _x, _y, k);
            }
        }
    }

    private static void layout_packPlace(PackNode a, PackNode b, PackNode c) {
        double db = a.r + c.r;
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        if (db != 0.0 && (dx != 0.0 || dy != 0.0)) {
            double da = b.r + c.r;
            double dc = dx * dx + dy * dy;
            da *= da;
            db *= db;
            double x = 0.5 + (db - da) / (2.0 * dc);
            double y = Math.sqrt(Math.max(0.0, 2.0 * da * (db + dc) - (db -= dc) * db - da * da)) / (2.0 * dc);
            c.x = a.x + x * dx + y * dy;
            c.y = a.y + x * dy - y * dx;
        } else {
            c.x = a.x + db;
            c.y = a.y;
        }
    }
}

