/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.layout.PartitionNode;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyBase;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public class PartitionLayout
extends HierarchyBase<PartitionNode, PartitionLayout> {
    private double[] sizeVal = new double[]{1.0, 1.0};

    private void position(PartitionNode node, double x, double dx, double dy) {
        ArrayEx children = node.children;
        node.x = x;
        node.y = (double)node.depth * dy;
        node.dx = dx;
        node.dy = dy;
        int n = 0;
        double localdx = dx;
        double localx = x;
        if (children != null && children.size() > 0) {
            n = children.size();
            int i = -1;
            double d = 0.0;
            double d2 = localdx = ObjectConverter.toBoolean(node.value) ? localdx / node.value : 0.0;
            while (++i < n) {
                PartitionNode c = (PartitionNode)children.get(i);
                d = c.value * localdx;
                this.position(c, localx, d, dy);
                localx += d;
            }
        }
    }

    private int depth(PartitionNode node) {
        ArrayEx children = node.children;
        int d = 0;
        if (children != null && children.size() > 0) {
            int n = children.size();
            int i = -1;
            while (++i < n) {
                d = Math.max(d, this.depth((PartitionNode)children.get(i)));
            }
        }
        return 1 + d;
    }

    public double[] size() {
        return this.sizeVal;
    }

    public PartitionLayout size(double[] newSize) {
        this.sizeVal = newSize;
        return this;
    }

    @Override
    public ArrayEx<PartitionNode> create(PartitionNode d) {
        ArrayEx<PartitionNode> nodes = super.create(d);
        this.position((PartitionNode)nodes.get(0), 0.0, this.sizeVal[0], this.sizeVal[1] / (double)this.depth((PartitionNode)nodes.get(0)));
        return nodes;
    }
}

