/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.arrays.Range;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.layout.SliceData;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.util.Comparator;
import java.util.List;

public class PieLayout
implements ValueFunction<Object, Object[]> {
    private ValueFunction<? super PieLayout, Object> _value = VALUE;
    private Comparator<Object> _sort;
    private Object _startAngle = 0;
    private Object _endAngle = Math.PI * 2;
    private Object _padAngle = 0;
    private boolean sortDefined = false;
    private static ValueFunction<? super PieLayout, Object> VALUE = new ValueFunction<PieLayout, Object>(){

        @Override
        public Object getValue(PieLayout context, Object data, int index, int groupIndex) {
            return Math.abs(ObjectConverter.toDouble(data));
        }
    };

    @Override
    @SwiftMethodOverload(skip=true)
    public Object[] getValue(Object context, Object data, int index, int groupIndex) {
        return this.pie((List)data, index);
    }

    public SliceData[] pie(List<Object> info) {
        return this.pie(info, -1);
    }

    public SliceData[] pie(final List<Object> data, int index) {
        final PieLayout self = this;
        int n = data.size();
        final ArrayEx<Number> values = ArrayEx.map(data, new ArrayEx.ArrayValueFunction<Object, Number>(){

            @Override
            public Number getValue(Object currentValue, int i, ArrayEx<Object> array) {
                return Math.abs(ObjectConverter.toDouble(self._value.getValue(self, currentValue, i, -1)));
            }
        });
        double a = ObjectConverter.toDouble(this._startAngle instanceof ValueFunction ? ((ValueFunction)this._startAngle).getValue(this, data, index, -1) : this._startAngle);
        double da = ObjectConverter.toDouble(this._endAngle instanceof ValueFunction ? ((ValueFunction)this._endAngle).getValue(this, data, index, -1) : this._endAngle) - a;
        double p = Math.min(Math.abs(da) / (double)n, ObjectConverter.toDouble(this._padAngle instanceof ValueFunction ? ((ValueFunction)this._padAngle).getValue(this, data, index, -1) : this._padAngle));
        double pa = p * (double)(da < 0.0 ? -1 : 1);
        double k = ObjectConverter.asDouble(Rave.sum(values)) == 0.0 ? 0.0 : (da - (double)n * pa) / ObjectConverter.asDouble(Rave.sum(values));
        ArrayEx<Number> indexArr = Range.create(data.size());
        if (!this.sortDefined) {
            indexArr.sort(new Comparator<Number>(){

                @Override
                public int compare(Number i, Number j) {
                    return ObjectConverter.toInt(values.get(ObjectConverter.toInt(j))) - ((Number)values.get(ObjectConverter.toInt(i))).intValue();
                }
            });
        } else if (this.sortDefined && this._sort != null) {
            indexArr.sort(new Comparator<Number>(){

                @Override
                public int compare(Number i, Number j) {
                    return self._sort.compare(data.get(ObjectConverter.toInt(i)), data.get(ObjectConverter.toInt(j)));
                }
            });
        }
        SliceData[] arcs = new SliceData[data.size()];
        for (Object e : indexArr) {
            SliceData sd = new SliceData();
            Number v = sd.value = (Number)values.get(ObjectConverter.toInt(e));
            sd.data = data.get(ObjectConverter.toInt(e));
            sd.startAngle = a;
            sd.endAngle = a += ObjectConverter.toDouble(v) * k + pa;
            sd.innerRadius = 0.0;
            sd.outerRadius = 0.0;
            sd.padAngle = p;
            arcs[ObjectConverter.toInt(e)] = sd;
        }
        return arcs;
    }

    public PieLayout startAngle(ValueFunction<PieLayout, Object> startAngleFn) {
        this._startAngle = startAngleFn;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool", "String"})
    public PieLayout startAngle(Object value) {
        this._startAngle = value;
        return this;
    }

    public Object startAngle() {
        return this._startAngle;
    }

    public PieLayout endAngle(ValueFunction<PieLayout, Object> endAngleFn) {
        this._endAngle = endAngleFn;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool", "String"})
    public PieLayout endAngle(Object value) {
        this._endAngle = value;
        return this;
    }

    public Object endAngle() {
        return this._endAngle;
    }

    public PieLayout value(ValueFunction<? super PieLayout, Object> valueFn) {
        this._value = valueFn;
        return this;
    }

    public ValueFunction<? super PieLayout, Object> value() {
        return this._value;
    }

    public PieLayout padAngle(ValueFunction<PieLayout, Object> padAngleFn) {
        this._padAngle = padAngleFn;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool", "String"})
    public PieLayout padAngle(Object value) {
        this._padAngle = value;
        return this;
    }

    public Object padAngle() {
        return this._padAngle;
    }

    public PieLayout sort(Comparator<Object> sortFn) {
        this.sortDefined = true;
        this._sort = sortFn;
        return this;
    }

    public Comparator<Object> sort() {
        return this._sort;
    }
}

