/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.arrays.Range;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.util.Identity;
import com.ibm.vida.rave.core.layout.StackNode;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.util.Comparator;

public class StackLayout
implements ValueFunction<Object, Object[]> {
    protected ValueFunction<Object, ArrayEx<?>> valuesFn = DEFAULT_VALUES_FUNCTION;
    protected ValueFunction<Object, ArrayEx<Integer>> orderFn = DEFAULT_STACKORDER_FUNCTION;
    protected ValueFunction<Object, ArrayEx<? extends Number>> offsetFn = DEFAULT_STACKOFFSETZERO;
    protected StackOutFunction outFn = DEFAULT_OUT_FUNCTION;
    protected AccumulatorFunction accumulatorFn = DEFAULT_ACCUMULATOR_FUNCTION;
    private static final AccumulatorFunction DEFAULT_ACCUMULATOR_FUNCTION = new AccumulatorFunction(){

        @Override
        public double getValue(StackLayout context, double offsetValue, double lastValue, double currentValue, double accumulatedVal, int seriesIndex, int dataIndex) {
            return accumulatedVal + lastValue;
        }
    };
    private final AccumulatorFunction POSITIVES_NEGATIVES_ACCUMULATOR_FUNCTION = new AccumulatorFunction(){
        double accumulatedPos = 0.0;
        double accumulatedNeg = 0.0;

        @Override
        public double getValue(StackLayout context, double offsetValue, double lastValue, double currentValue, double accumulatedVal, int seriesIndex, int dataIndex) {
            if (dataIndex == 0) {
                if (accumulatedVal >= 0.0) {
                    this.accumulatedPos = accumulatedVal;
                    this.accumulatedNeg = 0.0;
                } else {
                    this.accumulatedPos = 0.0;
                    this.accumulatedNeg = accumulatedVal;
                }
            }
            if (lastValue >= 0.0) {
                this.accumulatedPos += lastValue;
            } else {
                this.accumulatedNeg += lastValue;
            }
            if (currentValue >= 0.0) {
                return this.accumulatedPos;
            }
            return this.accumulatedNeg;
        }
    };
    private final ES6Map<String, AccumulatorFunction> r2_layout_stackAccumulators = this.initialize_r2_layout_stackAccumulators();
    protected ValueFunction<Object, Object> xFn = DEFAULT_X_FUNCTION;
    protected ValueFunction<Object, Object> yFn = DEFAULT_Y_FUNCTION;
    private static ValueFunction<Object, ArrayEx<?>> DEFAULT_VALUES_FUNCTION = Identity.create();
    private static ValueFunction<Object, ArrayEx<Integer>> DEFAULT_STACKORDER_FUNCTION = new ValueFunction<Object, ArrayEx<Integer>>(){

        @Override
        public ArrayEx<Integer> getValue(Object context, Object data, int index, int groupIndex) {
            ArrayEx aData = (ArrayEx)data;
            return ObjectConverter.numberArrayAsIntegerArray(Range.create(aData.length()));
        }
    };
    private static ValueFunction<Object, ArrayEx<? extends Number>> DEFAULT_STACKOFFSETZERO = new ValueFunction<Object, ArrayEx<? extends Number>>(){

        @Override
        public ArrayEx<Double> getValue(Object context, Object data, int index, int groupIndex) {
            int j = -1;
            ArrayEx child = (ArrayEx)((ArrayEx)data).get(0);
            int m = child.length();
            ArrayEx<Double> y0 = new ArrayEx<Double>();
            while (++j < m) {
                y0.set(j, 0.0);
            }
            return y0;
        }
    };
    private static StackOutFunction DEFAULT_OUT_FUNCTION = new StackOutFunction(){

        @Override
        public void updateValue(Object context, Object stackNode, double y0, Object y) {
            StackNode node = (StackNode)stackNode;
            node.y0 = y0;
            node.y = y;
        }
    };
    private static ValueFunction<Object, Object> DEFAULT_X_FUNCTION = new ValueFunction<Object, Object>(){

        @Override
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((StackNode)data).x;
        }
    };
    private static ValueFunction<Object, Object> DEFAULT_Y_FUNCTION = new ValueFunction<Object, Object>(){

        @Override
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((StackNode)data).y;
        }
    };
    static ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Double>>, Double> r2_layout_stackMaxIndex = new ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Double>>, Double>(){

        @Override
        public Double getValue(ArrayEx<ArrayEx<Double>> currentValue, int index, ArrayEx<ArrayEx<ArrayEx<Double>>> array) {
            double j = 0.0;
            ArrayEx parentArray = (ArrayEx)currentValue.get(0);
            double v = (Double)parentArray.get(1);
            double k = 0.0;
            int n = array.length();
            for (int i = 0; i < n; ++i) {
                parentArray = (ArrayEx)currentValue.get(i);
                k = (Double)parentArray.get(1);
                if (!(k > v)) continue;
                j = i;
                v = k;
            }
            return j;
        }
    };
    static ArrayEx.Accumulator<Double, ArrayEx<Double>> r2_layout_stackSum = new ArrayEx.Accumulator<Double, ArrayEx<Double>>(){

        @Override
        public Double reduce(Double previousValue, ArrayEx<Double> currentValue, int index, ArrayEx<ArrayEx<Double>> array) {
            return previousValue + (Double)currentValue.get(1);
        }
    };
    static ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Double>>, Double> r2_layout_stackReduceSum = new ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Double>>, Double>(){

        @Override
        public Double getValue(ArrayEx<ArrayEx<Double>> currentValue, int index, ArrayEx<ArrayEx<ArrayEx<Double>>> array) {
            return currentValue.reduce(r2_layout_stackSum, 0.0);
        }
    };
    private static ValueFunction<Object, ArrayEx<Integer>> STACKORDER_REVERSE = new ValueFunction<Object, ArrayEx<Integer>>(){

        @Override
        public ArrayEx<Integer> getValue(Object context, Object data, int index, int groupIndex) {
            ArrayEx aData = (ArrayEx)data;
            return ObjectConverter.numberArrayAsIntegerArray(Range.create(aData.length())).reverse();
        }
    };
    private static ValueFunction<Object, ArrayEx<Integer>> STACKORDER_INSIDE_OUT = new ValueFunction<Object, ArrayEx<Integer>>(){

        @Override
        public ArrayEx<Integer> getValue(Object context, Object data, int index, int groupIndex) {
            ArrayEx aData = (ArrayEx)data;
            int n = aData.length();
            int j = 0;
            final ArrayEx<Double> max = aData.map(r2_layout_stackMaxIndex);
            ArrayEx<Double> sums = aData.map(r2_layout_stackReduceSum);
            ArrayEx<Number> sortedIndex = Rave.range(n).sort(new Comparator<Number>(){

                @Override
                public int compare(Number obj1, Number obj2) {
                    return (int)((Double)max.get(ObjectConverter.toInt(obj1)) - (Double)max.get(ObjectConverter.toInt(obj2)));
                }
            });
            double top = 0.0;
            double bottom = 0.0;
            ArrayEx<Integer> tops = new ArrayEx<Integer>();
            ArrayEx<Integer> bottoms = new ArrayEx<Integer>();
            for (int i = 0; i < n; ++i) {
                j = ObjectConverter.toInt(sortedIndex.get(i));
                if (top < bottom) {
                    top += ObjectConverter.asDouble(sums.get(j)).doubleValue();
                    tops.push(j);
                    continue;
                }
                bottom += ((Double)sums.get(j)).doubleValue();
                bottoms.push(j);
            }
            return bottoms.reverse().concat(tops);
        }
    };
    private static ES6Map<String, ValueFunction<Object, ArrayEx<Integer>>> r2_layout_stackOrders = StackLayout.initialize_r2_layout_stackOrders();
    private static ValueFunction<Object, ArrayEx<? extends Number>> STACKOFFSET_SILHOUETTE = new ValueFunction<Object, ArrayEx<? extends Number>>(){

        @Override
        public ArrayEx<Double> getValue(Object context, Object data, int index, int groupIndex) {
            int j;
            ArrayEx aData = (ArrayEx)data;
            int n = aData.length();
            int m = ((ArrayEx)aData.get(0)).length();
            ArrayEx<Double> sums = new ArrayEx<Double>();
            double max = 0.0;
            ArrayEx<Double> y0 = new ArrayEx<Double>();
            for (j = 0; j < m; ++j) {
                double o = 0.0;
                for (int i = 0; i < n; ++i) {
                    o += ((Double)((ArrayEx)((ArrayEx)aData.get(i)).get(j)).get(1)).doubleValue();
                }
                if (o > max) {
                    max = o;
                }
                sums.push(o);
            }
            for (j = 0; j < m; ++j) {
                y0.set(j, max - (Double)sums.get(j) / 2.0);
            }
            return y0;
        }
    };
    private static ValueFunction<Object, ArrayEx<? extends Number>> STACKOFFSET_WIGGLE = new ValueFunction<Object, ArrayEx<? extends Number>>(){

        @Override
        public ArrayEx<Double> getValue(Object context, Object data, int index, int groupIndex) {
            int j;
            ArrayEx aData = (ArrayEx)data;
            int n = aData.length();
            ArrayEx x = (ArrayEx)aData.get(0);
            int m = x.length();
            double s1 = 0.0;
            double s2 = 0.0;
            double s3 = 0.0;
            double dx = 0.0;
            double o = 0.0;
            double o0 = 0.0;
            ArrayEx<Double> y0 = new ArrayEx<Double>();
            y0.set(0, 0.0);
            for (j = 1; j < m; ++j) {
                int i;
                s1 = 0.0;
                for (i = 0; i < n; ++i) {
                    s1 += ObjectConverter.asDouble(((ArrayEx)((ArrayEx)aData.get(i)).get(j)).get(1)).doubleValue();
                }
                s2 = 0.0;
                dx = ObjectConverter.asDouble(((ArrayEx)x.get(j)).get(0)) - ObjectConverter.asDouble(((ArrayEx)x.get(j - 1)).get(0));
                for (i = 0; i < n; ++i) {
                    ArrayEx isElement = (ArrayEx)aData.get(i);
                    s3 = (ObjectConverter.asDouble(((ArrayEx)isElement.get(j)).get(1)) - ObjectConverter.asDouble(((ArrayEx)isElement.get(j - 1)).get(1))) / (2.0 * dx);
                    for (int k = 0; k < i; ++k) {
                        ArrayEx ksElement = (ArrayEx)aData.get(k);
                        s3 += (ObjectConverter.asDouble(((ArrayEx)ksElement.get(j)).get(1)) - ObjectConverter.asDouble(((ArrayEx)ksElement.get(j - 1)).get(1))) / dx;
                    }
                    s2 += s3 * ObjectConverter.asDouble(((ArrayEx)isElement.get(j)).get(1));
                }
                if (s1 != 0.0) {
                    o -= s2 / s1 * dx;
                }
                y0.set(j, o);
                if (!(o < o0)) continue;
                o0 = o;
            }
            for (j = 0; j < m; ++j) {
                Double val = (Double)y0.get(j);
                y0.set(j, val - o0);
            }
            return y0;
        }
    };
    private static ValueFunction<Object, ArrayEx<? extends Number>> STACKOFFSET_EXPAND = new ValueFunction<Object, ArrayEx<? extends Number>>(){

        @Override
        public ArrayEx<Double> getValue(Object context, Object data, int index, int groupIndex) {
            int j;
            ArrayEx aData = (ArrayEx)data;
            int n = aData.length();
            int m = ((ArrayEx)aData.get(0)).length();
            double k = 1.0 / (double)n;
            double o = 0.0;
            ArrayEx<Double> y0 = new ArrayEx<Double>();
            for (j = 0; j < m; ++j) {
                ArrayEx ijElement;
                int i;
                o = 0.0;
                for (i = 0; i < n; ++i) {
                    o += ((Double)((ArrayEx)((ArrayEx)aData.get(i)).get(j)).get(1)).doubleValue();
                }
                if (o != 0.0) {
                    for (i = 0; i < n; ++i) {
                        ijElement = (ArrayEx)((ArrayEx)aData.get(i)).get(j);
                        Double val = (Double)ijElement.get(1);
                        ijElement.set(1, val / o);
                    }
                    continue;
                }
                for (i = 0; i < n; ++i) {
                    ijElement = (ArrayEx)((ArrayEx)aData.get(i)).get(j);
                    ijElement.set(1, k);
                }
            }
            for (j = 0; j < m; ++j) {
                y0.set(j, 0.0);
            }
            return y0;
        }
    };
    private static ES6Map<String, ValueFunction<Object, ArrayEx<? extends Number>>> r2_layout_stackOffsets = StackLayout.initialize_r2_layout_stackOffsets();

    @Override
    @SwiftMethodOverload(skip=true)
    public Object[] getValue(Object context, Object data, int index, int groupIndex) {
        return this.stack((ArrayEx)data, index).toArray();
    }

    public ArrayEx<?> stack(ArrayEx<?> data, int index) {
        ArrayEx<?> objData = data;
        int n = data.length();
        if (n == 0) {
            return data;
        }
        final StackLayout self = this;
        ArrayEx<ArrayEx<Object>> series = objData.map(new ArrayEx.ArrayValueFunction<Object, ArrayEx<Object>>(){

            @Override
            public ArrayEx<Object> getValue(Object currentValue, int currentIndex, ArrayEx<Object> array) {
                return self.valuesFn.getValue(self, currentValue, currentIndex, -1);
            }
        });
        ArrayEx<ArrayEx<ArrayEx<Double>>> points = series.map(new ArrayEx.ArrayValueFunction<ArrayEx<Object>, ArrayEx<ArrayEx<Double>>>(){

            @Override
            public ArrayEx<ArrayEx<Double>> getValue(ArrayEx<Object> currentValue, int notUsedindex, ArrayEx<ArrayEx<Object>> notUsedarray) {
                return currentValue.map(new ArrayEx.ArrayValueFunction<Object, ArrayEx<Double>>(){

                    @Override
                    public ArrayEx<Double> getValue(Object pointsCurrentValue, int pointIndex, ArrayEx<Object> pointArray) {
                        double xVal = ObjectConverter.toDouble(self.xFn.getValue(self, pointsCurrentValue, pointIndex, -1));
                        double yVal = ObjectConverter.toDouble(self.yFn.getValue(self, pointsCurrentValue, pointIndex, -1));
                        return new ArrayEx<Double>(xVal, yVal);
                    }
                });
            }
        });
        ArrayEx<Integer> orders = this.orderFn.getValue(this, points, index, -1);
        series = Rave.permute(series, orders);
        points = Rave.permute(points, orders);
        ArrayEx<? extends Number> offsets = this.offsetFn.getValue(this, points, index, -1);
        int m = ((ArrayEx)series.get(0)).length();
        for (int j = 0; j < m; ++j) {
            double o;
            double accumulatedVal = o = ObjectConverter.asDouble(offsets.get(j)).doubleValue();
            this.outFn.updateValue(this, ((ArrayEx)series.get(0)).get(j), o, ((ArrayEx)((ArrayEx)points.get(0)).get(j)).get(1));
            for (int i = 1; i < n; ++i) {
                double lastVal = (Double)((ArrayEx)((ArrayEx)points.get(i - 1)).get(j)).get(1);
                double currentVal = (Double)((ArrayEx)((ArrayEx)points.get(i)).get(j)).get(1);
                accumulatedVal = this.accumulatorFn.getValue(this, o, lastVal, currentVal, accumulatedVal, j, i - 1);
                this.outFn.updateValue(this, ((ArrayEx)series.get(i)).get(j), accumulatedVal, currentVal);
            }
        }
        return data;
    }

    public ArrayEx<?> stack(ArrayEx<?> data) {
        return this.stack(data, -1);
    }

    public ValueFunction<Object, Object> x() {
        return this.xFn;
    }

    public StackLayout x(ValueFunction<Object, Object> newXFn) {
        this.xFn = newXFn;
        return this;
    }

    public ValueFunction<Object, Object> y() {
        return this.yFn;
    }

    public StackLayout y(ValueFunction<Object, Object> newYFn) {
        this.yFn = newYFn;
        return this;
    }

    public StackOutFunction out() {
        return this.outFn;
    }

    public StackLayout out(StackOutFunction newOutFn) {
        this.outFn = newOutFn;
        return this;
    }

    public ValueFunction<Object, ArrayEx<?>> values() {
        return this.valuesFn;
    }

    public StackLayout values(ValueFunction<Object, ArrayEx<?>> newValuesFn) {
        this.valuesFn = newValuesFn;
        return this;
    }

    public ValueFunction<Object, ArrayEx<Integer>> order() {
        return this.orderFn;
    }

    public StackLayout order(ValueFunction<Object, ArrayEx<Integer>> newOrderFn) {
        this.orderFn = newOrderFn != null ? newOrderFn : DEFAULT_STACKORDER_FUNCTION;
        return this;
    }

    public StackLayout order(String orderType) {
        ValueFunction<Object, ArrayEx<Integer>> requestedOrderFn = r2_layout_stackOrders.get(orderType);
        if (requestedOrderFn == null) {
            requestedOrderFn = DEFAULT_STACKORDER_FUNCTION;
        }
        this.orderFn = requestedOrderFn;
        return this;
    }

    public StackLayout accumulator(AccumulatorFunction newAccumulatorFn) {
        this.accumulatorFn = newAccumulatorFn != null ? newAccumulatorFn : DEFAULT_ACCUMULATOR_FUNCTION;
        return this;
    }

    public StackLayout accumulator(String accumulator) {
        AccumulatorFunction requestedAccumulatorFn = this.r2_layout_stackAccumulators.get(accumulator);
        if (requestedAccumulatorFn == null) {
            requestedAccumulatorFn = DEFAULT_ACCUMULATOR_FUNCTION;
        }
        this.accumulatorFn = requestedAccumulatorFn;
        return this;
    }

    public AccumulatorFunction accumulator() {
        return this.accumulatorFn;
    }

    public ValueFunction<Object, ArrayEx<? extends Number>> offset() {
        return this.offsetFn;
    }

    public StackLayout offset(ValueFunction<Object, ArrayEx<? extends Number>> newOffsetFn) {
        this.offsetFn = newOffsetFn != null ? newOffsetFn : DEFAULT_STACKOFFSETZERO;
        return this;
    }

    public StackLayout offset(String offsetType) {
        ValueFunction<Object, ArrayEx<? extends Number>> requestedOffsetFn = r2_layout_stackOffsets.get(offsetType);
        if (requestedOffsetFn == null) {
            requestedOffsetFn = DEFAULT_STACKOFFSETZERO;
        }
        this.offsetFn = requestedOffsetFn;
        return this;
    }

    private ES6Map<String, AccumulatorFunction> initialize_r2_layout_stackAccumulators() {
        ES6Map<String, AccumulatorFunction> _r2_layout_stackAccumulators = ES6Map.create();
        _r2_layout_stackAccumulators.set("default", DEFAULT_ACCUMULATOR_FUNCTION);
        _r2_layout_stackAccumulators.set("separate-positives-negatives", this.POSITIVES_NEGATIVES_ACCUMULATOR_FUNCTION);
        return _r2_layout_stackAccumulators;
    }

    private static ES6Map<String, ValueFunction<Object, ArrayEx<Integer>>> initialize_r2_layout_stackOrders() {
        ES6Map<String, ValueFunction<Object, ArrayEx<Integer>>> r2_layout_stackOrders = ES6Map.create();
        r2_layout_stackOrders.set("inside-out", STACKORDER_INSIDE_OUT);
        r2_layout_stackOrders.set("reverse", STACKORDER_REVERSE);
        r2_layout_stackOrders.set("default", DEFAULT_STACKORDER_FUNCTION);
        return r2_layout_stackOrders;
    }

    private static ES6Map<String, ValueFunction<Object, ArrayEx<? extends Number>>> initialize_r2_layout_stackOffsets() {
        ES6Map<String, ValueFunction<Object, ArrayEx<? extends Number>>> r2_layout_stackOffsets = ES6Map.create();
        r2_layout_stackOffsets.set("silhouette", STACKOFFSET_SILHOUETTE);
        r2_layout_stackOffsets.set("wiggle", STACKOFFSET_WIGGLE);
        r2_layout_stackOffsets.set("expand", STACKOFFSET_EXPAND);
        r2_layout_stackOffsets.set("zero", DEFAULT_STACKOFFSETZERO);
        return r2_layout_stackOffsets;
    }

    @FunctionClass(value="getValue", contextInvocation=true)
    @SwiftClosure(value="getValue")
    public static interface AccumulatorFunction {
        public double getValue(StackLayout var1, double var2, double var4, double var6, double var8, int var10, int var11);
    }

    @FunctionClass(value="updateValue", contextInvocation=true)
    @SwiftClosure(value="updateValue")
    public static interface StackOutFunction {
        public void updateValue(Object var1, Object var2, double var3, Object var5);
    }
}

