/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout.chord;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.layout.chord.ChordData;
import com.ibm.vida.rave.core.layout.chord.GroupData;
import com.ibm.vida.rave.core.layout.chord.MatrixDataStruct;
import com.ibm.vida.rave.core.layout.chord.SubGroupData;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.util.Comparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ChordLayout {
    private List<ChordData> _chords;
    private ArrayEx<GroupData> _groups;
    private List<? extends List<?>> _matrix;
    private int n = 0;
    private double _padding = 0.0;
    private SingleValueFunction<Double, Object> valueAccessor = DEFAULT_ACCESSOR_FN;
    Comparator<Object> _sortGroups;
    Comparator<Object> _sortSubgroups;
    private Comparator<Object> _sortChords;
    public GetterValueFunction<ArrayEx<GroupData>> groups;
    public GetterValueFunction<List<ChordData>> chords;
    private static SingleValueFunction<Double, Object> DEFAULT_ACCESSOR_FN = new SingleValueFunction<Double, Object>(){

        @Override
        public Double getValue(Object data) {
            return ObjectConverter.toDouble(data);
        }
    };

    private void relayout() {
        int j;
        double x;
        OMap<String, SubGroupData> subgroups = new OMap<String, SubGroupData>();
        ArrayEx<Double> groupSums = new ArrayEx<Double>();
        Number[] groupIndex = Rave.range(this.n).toArray(new Number[0]);
        Number[][] subgroupIndex = new Number[this.n][];
        this._chords = new ArrayList<ChordData>();
        this._groups = new ArrayEx();
        double k = 0.0;
        int i = -1;
        while (++i < this.n) {
            x = 0.0;
            j = -1;
            while (++j < this.n) {
                x += this.valueAccessor.getValue(this._matrix.get(i).get(j)).doubleValue();
            }
            groupSums.set(i, x);
            subgroupIndex[i] = Rave.range(this.n).toArray(new Number[0]);
            k += x;
        }
        if (this._sortGroups != null) {
            Arrays.sort(groupIndex, new GroupAndSubGroupComparator(this, groupSums, false, this.valueAccessor));
        }
        if (this._sortSubgroups != null) {
            for (int index = 0; index < subgroupIndex.length; ++index) {
                Number[] aToSOrt = subgroupIndex[index];
                Arrays.sort(aToSOrt, new GroupAndSubGroupComparator(this, this._matrix.get(index), true, this.valueAccessor));
            }
        }
        k = (Math.PI * 2 - this._padding * (double)this.n) / k;
        x = 0.0;
        i = -1;
        while (++i < this.n) {
            double x0 = x;
            j = -1;
            int di = 0;
            while (++j < this.n) {
                di = ObjectConverter.toInt(groupIndex[i]);
                int dj = ObjectConverter.toInt(subgroupIndex[di][j]);
                double numericV = this.valueAccessor.getValue(this._matrix.get(di).get(dj));
                double a0 = x;
                double a1 = x += numericV * k;
                subgroups.put(di + "-" + dj, new SubGroupData(di, dj, a0, a1, numericV, this._matrix.get(di).get(dj)));
            }
            this._groups.set(di, new GroupData(di, x0, x, (x - x0) / k, this._matrix.get(di).get(0) instanceof MatrixDataStruct ? ((MatrixDataStruct)this._matrix.get((int)di).get((int)0)).sourceGroupInfo : null));
            x += this._padding;
        }
        i = -1;
        while (++i < this.n) {
            j = i - 1;
            while (++j < this.n) {
                SubGroupData source = (SubGroupData)subgroups.get(i + "-" + j);
                SubGroupData target = (SubGroupData)subgroups.get(j + "-" + i);
                if (source.value == 0.0 && target.value == 0.0) continue;
                ChordData cd = new ChordData();
                if (source.value < target.value) {
                    cd.source = target;
                    cd.target = source;
                } else {
                    cd.source = source;
                    cd.target = target;
                }
                cd.originalData = this._matrix.get(i).get(j) instanceof MatrixDataStruct ? ((MatrixDataStruct)this._matrix.get((int)i).get((int)j)).originalData : null;
                this._chords.add(cd);
            }
        }
        if (this._sortChords != null) {
            this.resort();
        }
    }

    public void resort() {
        Collections.sort(this._chords, new ChordsComparator(this._sortChords));
    }

    public ChordLayout matrix(List<? extends List<?>> x) {
        this._matrix = x;
        this.n = x.size();
        this._chords = null;
        this._groups = null;
        return this;
    }

    public List<? extends List<?>> matrix() {
        return this._matrix;
    }

    public SingleValueFunction<Double, Object> value() {
        return this.valueAccessor;
    }

    public ChordLayout value(SingleValueFunction<Double, Object> valueFn) {
        this.valueAccessor = valueFn;
        return this;
    }

    public ChordLayout padding(double x) {
        this._padding = x;
        this._chords = null;
        this._groups = null;
        return this;
    }

    public double padding() {
        return this._padding;
    }

    public Comparator<?> sortGroups() {
        return this._sortGroups;
    }

    public ChordLayout sortGroups(Comparator<?> sortGroupFn) {
        this._sortGroups = sortGroupFn;
        this._chords = null;
        this._groups = null;
        return this;
    }

    public Comparator<?> sortSubgroups() {
        return this._sortSubgroups;
    }

    public ChordLayout sortSubgroups(Comparator<?> sortSubGroupFn) {
        this._sortSubgroups = sortSubGroupFn;
        this._chords = null;
        return this;
    }

    public Comparator<?> sortChords() {
        return this._sortChords;
    }

    public ChordLayout sortChords(Comparator<?> sortChordsFn) {
        this._sortChords = sortChordsFn;
        if (this._chords != null) {
            this.resort();
        }
        return this;
    }

    public ChordLayout() {
        final ChordLayout self = this;
        this.groups = new GetterValueFunction<ArrayEx<GroupData>>(){

            @Override
            public ArrayEx<GroupData> getValue(ChordLayout context) {
                if (self._groups == null) {
                    self.relayout();
                }
                return self._groups;
            }
        };
        this.chords = new GetterValueFunction<List<ChordData>>(){

            @Override
            public List<ChordData> getValue(ChordLayout context) {
                if (self._chords == null) {
                    self.relayout();
                }
                return self._chords;
            }
        };
    }

    @FunctionClass(value="getValue", contextInvocation=true)
    @SwiftClosure(value="getValue")
    public static interface GetterValueFunction<T> {
        public T getValue(ChordLayout var1);
    }

    private static class ChordsComparator
    implements Comparator<ChordData> {
        private final Comparator<Object> sortGroups;

        public ChordsComparator(Comparator<?> _sortGroups) {
            this.sortGroups = _sortGroups;
        }

        @Override
        public int compare(ChordData a, ChordData b) {
            return this.sortGroups.compare((a.source.value + a.target.value) / 2.0, (b.source.value + b.target.value) / 2.0);
        }
    }

    private static class GroupAndSubGroupComparator
    implements Comparator<Number> {
        private final List<Object> dataToSort;
        private final ChordLayout chord;
        private final boolean subGroup;
        private final SingleValueFunction<Double, Object> valGetFn;

        public GroupAndSubGroupComparator(ChordLayout _chord, List<?> _dataToSort, boolean _subGroups, SingleValueFunction<Double, Object> theValGetFn) {
            this.dataToSort = _dataToSort;
            this.chord = _chord;
            this.subGroup = _subGroups;
            this.valGetFn = theValGetFn;
        }

        @Override
        public int compare(Number o1, Number o2) {
            if (!this.subGroup) {
                return this.chord._sortGroups.compare(this.dataToSort.get(o1.intValue()), this.dataToSort.get(o2.intValue()));
            }
            return this.chord._sortSubgroups.compare(this.valGetFn.getValue(this.dataToSort.get(o1.intValue())), this.valGetFn.getValue(this.dataToSort.get(o2.intValue())));
        }
    }
}

