/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout.cluster;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.layout.cluster.ClusterNode;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyBase;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyUtil;
import com.ibm.vida.rave.core.layout.tree.Tree;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import java.util.List;

public class Cluster
extends HierarchyBase<ClusterNode, Cluster> {
    private final Tree.GetSeparation<ClusterNode> defaultSeparationFunction = new Tree.GetSeparation<ClusterNode>(){

        @Override
        public int treeSeparation(ClusterNode a, ClusterNode b) {
            return Tree.treeSeparation(a, b);
        }
    };
    private Tree.GetSeparation<ClusterNode> separationFunction = this.defaultSeparationFunction;
    private double[] _size = new double[]{1.0, 1.0};
    private boolean _nodeSize = false;
    ValueFunction<List<?>, ? extends Number> getChildY = new ValueFunction<List<?>, Double>(){

        @Override
        public Double getValue(List<?> context, Object child, int index, int groupIndex) {
            return ((ClusterNode)child).y;
        }
    };

    public Cluster() {
        this.sort(null);
        this.value(null);
    }

    @Override
    public ArrayEx<ClusterNode> create(ClusterNode d) {
        ArrayEx<ClusterNode> nodes = super.create(d);
        final ClusterNode[] root = new ClusterNode[]{(ClusterNode)nodes.get(0)};
        final ClusterNode[] previousNode = new ClusterNode[1];
        final int[] x = new int[]{0};
        final Cluster self = this;
        HierarchyUtil.visitAfter(root[0], new HierarchyUtil.Visitor<ClusterNode>(){

            @Override
            public void visit(ClusterNode node) {
                ArrayEx children = node.children;
                if (children != null && children.size() > 0) {
                    node.x = self.clusterX(children);
                    node.y = self.clusterY(children);
                } else {
                    if (previousNode[0] != null) {
                        x[0] = x[0] + self.separationFunction.treeSeparation(node, previousNode[0]);
                        node.x = x[0];
                    } else {
                        node.x = 0.0;
                    }
                    node.y = 0.0;
                    previousNode[0] = node;
                }
            }
        });
        ClusterNode left = this.clusterLeft(root[0]);
        ClusterNode right = this.clusterRight(root[0]);
        final double[] x0 = new double[]{left.x - (double)this.separationFunction.treeSeparation(left, right) / 2.0};
        final double[] x1 = new double[]{right.x + (double)this.separationFunction.treeSeparation(right, left) / 2.0};
        HierarchyUtil.visitAfter(root[0], new HierarchyUtil.Visitor<ClusterNode>(){

            @Override
            public void visit(ClusterNode node) {
                if (self._nodeSize) {
                    node.x = (node.x - root[0].x) * self._size[0];
                    node.y = (root[0].y - node.y) * self._size[1];
                } else {
                    node.x = (node.x - x0[0]) / (x1[0] - x0[0]) * self._size[0];
                    node.y = (1.0 - (root[0].y > 0.0 ? node.y / root[0].y : 1.0)) * self._size[1];
                }
            }
        });
        return nodes;
    }

    private double clusterY(List<ClusterNode> children) {
        return 1.0 + ObjectConverter.asDouble(Rave.max(children, this.getChildY));
    }

    private double clusterX(List<ClusterNode> children) {
        double reduction = 0.0;
        reduction = this.reduce(children);
        return reduction / (double)children.size();
    }

    private double reduce(List<ClusterNode> children) {
        double reduction = 0.0;
        double previousReduction = 0.0;
        for (ClusterNode node : children) {
            previousReduction = reduction = previousReduction + node.x;
        }
        return reduction;
    }

    private ClusterNode clusterRight(ClusterNode node) {
        ArrayEx children = node.children;
        return children != null && children.size() > 0 ? this.clusterRight((ClusterNode)children.get(children.size() - 1)) : node;
    }

    private ClusterNode clusterLeft(ClusterNode node) {
        ArrayEx children = node.children;
        return children != null && children.size() > 0 ? this.clusterLeft((ClusterNode)children.get(0)) : node;
    }

    public Cluster separation(Tree.GetSeparation<ClusterNode> func) {
        this.separationFunction = func;
        return this;
    }

    public Tree.GetSeparation<ClusterNode> separation() {
        return this.separationFunction;
    }

    public double[] size() {
        return this._nodeSize ? null : this._size;
    }

    public Cluster size(double[] sizes) {
        this._size = sizes;
        this._nodeSize = sizes == null;
        return this;
    }

    public Cluster nodeSize(double[] nodeSize) {
        this._size = nodeSize;
        this._nodeSize = nodeSize != null;
        return this;
    }

    public double[] nodeSize() {
        return this._nodeSize ? this._size : null;
    }
}

