/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.layout.hierarchy;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyLink;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyNode;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyUtil;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.util.Comparator;
import java.util.List;

public abstract class HierarchyBase<T extends HierarchyNode<T>, S extends HierarchyBase<T, S>>
implements ValueFunction<Object, Object[]> {
    private final GetNodeChildren<T, S> defaultChildrenFunction = new GetNodeChildren<T, S>(){

        @Override
        public ArrayEx<T> get(S hierarchy, T node, int depth) {
            return ((HierarchyNode)node).children;
        }
    };
    private final GetNodeValue<T, S> defaultNodeValueFunction = new GetNodeValue<T, S>(){

        @Override
        public Object get(S hierarchy, T node, int depth) {
            return ((HierarchyNode)node).value;
        }
    };
    private final Comparator<T> defaultSortFunction = new Comparator<T>(){

        @Override
        public int compare(T a, T b) {
            return (int)(((HierarchyNode)b).value - ((HierarchyNode)a).value);
        }
    };
    protected GetNodeValue<T, S> nodeValueFunction = this.defaultNodeValueFunction;
    protected GetNodeChildren<T, S> childrenFunction = this.defaultChildrenFunction;
    protected Comparator<T> sortFunction = this.defaultSortFunction;
    @SwiftWeak
    public final HierarchyBase<T, S> nodes = this;

    @Override
    @SwiftMethodOverload(skip=true)
    public Object[] getValue(Object context, Object data, int index, int groupIndex) {
        return this.create((HierarchyNode)data).toArray();
    }

    public ArrayEx<T> create(T stackNode) {
        HierarchyNode root;
        ArrayEx<Object> stack = new ArrayEx<Object>();
        ArrayEx<HierarchyNode> nodes = new ArrayEx<HierarchyNode>();
        ((HierarchyNode)stackNode).depth = 0;
        stack.add(stackNode);
        while ((root = (HierarchyNode)stack.pop()) != null) {
            int n;
            nodes.add(root);
            ArrayEx<HierarchyNode> childs = this.childrenFunction.get(this, root, root.depth);
            if (childs != null && (n = childs.size()) > 0) {
                while (--n >= 0) {
                    HierarchyNode child = (HierarchyNode)childs.get(n);
                    stack.add(child);
                    child.parent = root;
                    child.depth = root.depth + 1;
                }
                if (this.nodeValueFunction != null) {
                    root.value = 0.0;
                }
                root.children = childs;
                continue;
            }
            if (this.nodeValueFunction != null) {
                double valueVal = ObjectConverter.toDouble(this.nodeValueFunction.get(this, root, root.depth));
                if (valueVal != valueVal) {
                    valueVal = 0.0;
                }
                root.value = valueVal;
            }
            root.children = (ArrayEx)Lang.undefined();
        }
        if (this.sortFunction != null || this.nodeValueFunction != null) {
            final HierarchyBase self = this;
            HierarchyUtil.visitAfter(stackNode, new HierarchyUtil.Visitor<T>(){

                @Override
                public void visit(T node) {
                    Object parent;
                    ArrayEx childs;
                    if (self.sortFunction != null && (childs = ((HierarchyNode)node).children) != null) {
                        childs.sort(self.sortFunction);
                    }
                    if (self.nodeValueFunction != null && (parent = ((HierarchyNode)node).parent) != null) {
                        ((HierarchyNode)parent).value += ((HierarchyNode)node).value;
                    }
                }
            });
        }
        return nodes;
    }

    public S sort(Comparator<T> func) {
        this.sortFunction = func;
        return (S)this;
    }

    public Comparator<T> sort() {
        return this.sortFunction;
    }

    public S children(GetNodeChildren<T, S> func) {
        this.childrenFunction = func;
        return (S)this;
    }

    public GetNodeChildren<T, S> children() {
        return this.childrenFunction;
    }

    public S value(GetNodeValue<T, S> func) {
        this.nodeValueFunction = func;
        return (S)this;
    }

    public GetNodeValue<T, S> value() {
        return this.nodeValueFunction;
    }

    public List<HierarchyLink<T>> links(List<T> nodes) {
        return HierarchyUtil.links(nodes);
    }

    @FunctionClass(value="get", contextInvocation=true)
    @SwiftClosure(value="get")
    public static interface GetNodeChildren<T extends HierarchyNode<T>, S extends HierarchyBase<T, S>> {
        public ArrayEx<T> get(S var1, T var2, int var3);
    }

    @FunctionClass(value="get", contextInvocation=true)
    @SwiftClosure(value="get")
    public static interface GetNodeValue<T extends HierarchyNode<T>, S extends HierarchyBase<T, S>> {
        public Object get(S var1, T var2, int var3);
    }
}

