/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.locale;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.format.FormatPrefix;
import com.ibm.vida.rave.core.format.Round;
import com.ibm.vida.rave.core.internal.format.Precision;
import com.ibm.vida.rave.core.internal.nativeImpl.NumberFormatHelper;
import com.ibm.vida.rave.core.internal.nativeImpl.RegExp;
import com.ibm.vida.rave.core.locale.FormatSpecifier;
import com.ibm.vida.rave.core.locale.LocaleObject;
import com.ibm.vida.rave.core.locale.NumberFormatter;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;

public class NumberFormat
implements FormatSpecifier {
    private final String[] locale_currency;
    private final String locale_decimal;
    private IdentityValueFunction formatGroup;
    public static final String format_re = "(?:([^{])?([<>=^]))?([+\\- ])?([$#])?(0)?(\\d+)?(,)?(\\.-?\\d+)?([a-z%])?";

    public NumberFormat(LocaleObject locale) {
        final String locale_thousands = locale.thousands;
        this.locale_decimal = locale.decimal;
        final double[] locale_grouping = locale.grouping == null ? new double[]{} : locale.grouping;
        this.locale_currency = locale.currency;
        NumberFormat self = this;
        this.formatGroup = ObjectConverter.toBoolean(locale_thousands) && locale_grouping.length > 0 ? new IdentityValueFunction(){

            @Override
            public String identity(String value, double width) {
                int i = value.length();
                ArrayEx<String> t = new ArrayEx<String>();
                int j = 0;
                double g = locale_grouping[0];
                int length = 0;
                while (i > 0 && g > 0.0) {
                    int n;
                    if ((double)length + g + 1.0 > width) {
                        g = Math.max(1.0, width - (double)length);
                    }
                    int zi = i;
                    double zg = g;
                    int z = zi = (int)((double)zi - zg);
                    if (z < 0) {
                        z = 0;
                    }
                    i = (int)((double)i - g);
                    t.push(value.substring(z, i + (int)g));
                    length = (int)((double)length + (g + 1.0));
                    if ((double)n > width) break;
                    j = (j + 1) % locale_grouping.length;
                    g = locale_grouping[j];
                }
                return t.reverse().join(locale_thousands);
            }
        } : new IdentityValueFunction(){

            @Override
            public String identity(String value, double width) {
                return value;
            }
        };
    }

    @Override
    public ValueFunction<Object, String> create(String specifier) {
        TypeValueFunction newType;
        RegExp.RegExpResult match = new RegExp(format_re, "i").exec(specifier);
        String fill = match.get(1) != null ? (String)match.get(1) : " ";
        String align = match.get(2) != null ? (String)match.get(2) : ">";
        String sign = match.get(3) != null ? (String)match.get(3) : "-";
        String symbol = match.get(4) != null ? (String)match.get(4) : "";
        String zfill = (String)match.get(5);
        String width = (String)match.get(6);
        String comma = (String)match.get(7);
        String precisionMatch = (String)match.get(8);
        String type = (String)match.get(9);
        int scale = 1;
        String prefix = "";
        String suffix = "";
        boolean integer = false;
        boolean exponent = true;
        int intwidth = 0;
        Integer precision = null;
        if (precisionMatch != null) {
            precision = ObjectConverter.toInt(precisionMatch.substring(1));
        }
        if (zfill != null || fill.equals("0") && align.equals("=")) {
            fill = "0";
            zfill = "0";
            align = "=";
            if (comma != null) {
                int w;
                intwidth = w = (int)ObjectConverter.toDouble(width);
            }
        }
        if (type != null) {
            if (type.equals("n")) {
                comma = "true";
                type = "g";
            } else if (type.equals("%")) {
                scale = 100;
                suffix = "%";
                type = "f";
            } else if (type.equals("p")) {
                scale = 100;
                suffix = "%";
                type = "r";
            } else if (type.equals("b") || type.equals("o") || type.equals("x") || type.equals("X")) {
                if (symbol.equals("#")) {
                    prefix = "0" + type.toLowerCase();
                }
            } else if (type.equals("c")) {
                exponent = false;
            } else if (type.equals("d")) {
                integer = true;
                precision = 0;
            } else if (type.equals("s")) {
                scale = -1;
                type = "r";
            }
        }
        if (symbol.equals("$")) {
            prefix = this.locale_currency[0];
            suffix = this.locale_currency[1];
        }
        if (type != null && type.equals("r") && precision == null) {
            type = "g";
        }
        if (precision != null) {
            int value = precision;
            if (type != null && type.equals("g")) {
                precision = Math.max(1, Math.min(21, value));
            } else if (type != null && type.equals("e") || type != null && type.equals("f")) {
                precision = Math.max(0, Math.min(20, value));
            }
        }
        if ((newType = this.formatTypes().get(type)) == null) {
            newType = this.formatTypeDefault();
        }
        String zcomma = zfill != null ? comma : (comma != null ? zfill : comma);
        final String _suffix = suffix;
        final boolean _exponent = exponent;
        final boolean _integer = integer;
        final String _sign = sign;
        final String _prefix = prefix;
        final String _zfill = zfill;
        final String _comma = comma;
        final Integer _precision = precision;
        final int _scale = scale;
        final TypeValueFunction _newType = newType;
        final String _zcomma = zcomma;
        final String _width = width;
        final String _align = align;
        final int _intwidth = intwidth;
        final String _fill = fill;
        final NumberFormat self = this;
        return new NumberFormatter(){

            @Override
            public String getValue(Object context, Object data, int index, int groupIndex) {
                String padding;
                String after;
                String before;
                String negative;
                double value = ObjectConverter.toDouble(data);
                String fullSuffix = _suffix;
                double v = value % 1.0;
                if (_integer && v != 0.0) {
                    return "";
                }
                if (value < 0.0 || value == 0.0 && 1.0 / value < 0.0) {
                    value = -value;
                    negative = "-";
                } else {
                    negative = _sign.equals("-") ? "" : _sign;
                }
                if (_scale < 0) {
                    FormatPrefix unit = FormatPrefix.formatPrefix(value, _precision);
                    value = unit.scale.scale(value);
                    fullSuffix = unit.symbol + _suffix;
                } else {
                    value *= (double)_scale;
                }
                String typeValue = _newType.type(value, _precision);
                int i = typeValue.lastIndexOf(".");
                if (i < 0) {
                    int j;
                    int n = j = _exponent ? typeValue.lastIndexOf("e") : -1;
                    if (j < 0) {
                        before = typeValue;
                        after = "";
                    } else {
                        before = typeValue.substring(0, j);
                        after = typeValue.substring(j);
                    }
                } else {
                    before = typeValue.substring(0, i);
                    after = self.locale_decimal + typeValue.substring(i + 1);
                }
                if (_zfill == null && _comma != null) {
                    before = self.formatGroup.identity(before, Double.POSITIVE_INFINITY);
                }
                int length = _prefix.length() + before.length() + after.length() + (_zcomma != null && !_zcomma.equals("0") ? 0 : negative.length());
                int intwidth = _intwidth;
                if (_width != null && !_width.equals("") && _intwidth == 0) {
                    intwidth = Integer.parseInt(_width);
                }
                if (length < intwidth) {
                    length = intwidth - length + 1;
                    padding = new ArrayEx(length).join(_fill);
                } else {
                    padding = "";
                }
                if (_zcomma != null && !_zcomma.equals("0")) {
                    before = self.formatGroup.identity(padding + before, padding.length() > 0 ? (double)(intwidth - after.length()) : Double.POSITIVE_INFINITY);
                }
                negative = negative + _prefix;
                String myValue = before + after;
                return (_align.equals("<") ? negative + myValue + padding : (_align.equals(">") ? padding + negative + myValue : (_align.equals("^") ? padding.substring(0, length >>= 1) + negative + myValue + padding.substring(length) : negative + (_zcomma != null && !_zcomma.equals("0") ? myValue : padding + myValue)))) + fullSuffix;
            }
        };
    }

    private ES6Map<String, TypeValueFunction> formatTypes() {
        ES6Map<String, TypeValueFunction> map = ES6Map.create();
        map.set("b", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                int v = (int)value;
                return Integer.toString(v, 2);
            }
        });
        map.set("c", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                char c = (char)value;
                return Character.toString(c);
            }
        });
        map.set("o", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                int v = (int)value;
                return Integer.toString(v, 8);
            }
        });
        map.set("x", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                return Long.toString((long)value, 16);
            }
        });
        map.set("X", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                return Long.toString((long)value, 16).toUpperCase();
            }
        });
        map.set("g", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                return NumberFormatHelper.toPrecision(value, precision);
            }
        });
        map.set("e", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                return precision != null ? NumberFormatHelper.toExponential(value, precision) : NumberFormatHelper.toExponential(value);
            }
        });
        map.set("f", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                String fixed = NumberFormatHelper.toFixed(value, ObjectConverter.toInt(precision));
                Double fixedDouble = ObjectConverter.toDouble(fixed);
                if (fixedDouble == Math.floor(fixedDouble) && !Double.isInfinite(fixedDouble) && ObjectConverter.toInt(precision) <= 0) {
                    Long intfixed = Math.round(fixedDouble);
                    return intfixed.toString();
                }
                return fixed;
            }
        });
        map.set("r", new TypeValueFunction(){

            @Override
            public String type(double value, Integer precision) {
                double rounded = Round.round(value, Precision.precision(value, precision));
                return NumberFormatHelper.toFixed(rounded, (int)Math.max(0.0, Math.min(20.0, Precision.precision(rounded * 1.000000000000001, precision))));
            }
        });
        return map;
    }

    private TypeValueFunction formatTypeDefault() {
        return new TypeValueFunction(){

            @Override
            public String type(double xx, Integer pp) {
                return ObjectConverter.toString(xx);
            }
        };
    }

    @FunctionClass(value="type", contextInvocation=false)
    @SwiftClosure(value="type")
    private static interface TypeValueFunction {
        public String type(double var1, Integer var3);
    }

    @FunctionClass(value="identity", contextInvocation=false)
    @SwiftClosure(value="identity")
    private static interface IdentityValueFunction {
        public String identity(String var1, double var2);
    }
}

