/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.locale;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.nativeImpl.RegExp;
import com.ibm.vida.rave.core.locale.LocaleObject;
import com.ibm.vida.rave.core.locale.TimeFormatSpecifier;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.format.Requote;
import com.ibm.vida.rave.core.nativeImpl.time.Date;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.time.DateUTC;
import com.ibm.vida.rave.core.time.FormatISO;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.core.time.Time;
import com.ibm.vida.rave.core.time.TimeFormatter;

public class TimeFormat
extends TimeFormatSpecifier {
    @SwiftWeak(value=false)
    public final TimeFormatSpecifier utc = this.createUTC();
    public final TimeFormatter iso = new FormatISO();
    private final OMap<String, InternalTimeFormatter> timeFormats = this.buildTimeFormat();
    private final LocaleObject locale;
    @InlineStringConstant
    private static final String TIME_PARSERS_LIST_KEY = "TIME_PARSERS_LIST_KEY";
    private final ES6Map<String, Integer> time_periodLookup = ES6Map.create();
    private static final OMap<String, String> time_formatPads = TimeFormat.initialize_time_formatPads();

    private OMap<String, TimeParsesValueFunction> getTimeParsers() {
        ArrayEx<TimeFormatParsers> timeFormatParsersList = (ArrayEx<TimeFormatParsers>)RaveContextManager.INSTANCE.getRaveContext().getData(TIME_PARSERS_LIST_KEY);
        if (timeFormatParsersList == null) {
            timeFormatParsersList = new ArrayEx<TimeFormatParsers>();
            TimeFormatParsers timeFormatParsers = new TimeFormatParsers(this);
            timeFormatParsersList.add(timeFormatParsers);
            RaveContextManager.INSTANCE.getRaveContext().putData(TIME_PARSERS_LIST_KEY, timeFormatParsersList);
            return timeFormatParsers.timeParsers;
        }
        for (int i = 0; i < timeFormatParsersList.size(); ++i) {
            TimeFormatParsers timeFormatParsers = (TimeFormatParsers)timeFormatParsersList.get(i);
            if (timeFormatParsers.timeFormat != this) continue;
            return timeFormatParsers.timeParsers;
        }
        TimeFormatParsers timeFormatParsers = new TimeFormatParsers(this);
        timeFormatParsersList.add(timeFormatParsers);
        return timeFormatParsers.timeParsers;
    }

    public TimeFormat(LocaleObject locale) {
        this.locale = locale;
        this.setTimePeriodLookup();
    }

    @Override
    public TimeFormatter create(final String template) {
        final int n = template.length();
        final TimeFormat self = this;
        return new TimeFormatter(){

            @Override
            public String toString() {
                return template;
            }

            @Override
            public IDate parse(String dateString) {
                return TimeFormat.parseImpl(self, template, dateString, false);
            }

            @Override
            public String getValue(Object context, Object date, int index, int groupIndex) {
                IDate dateObj = (IDate)date;
                ArrayEx<String> string = new ArrayEx<String>();
                int i = -1;
                int j = 0;
                while (++i < n) {
                    InternalTimeFormatter f;
                    String stringC;
                    if (Character.codePointAt(template, i) != 37) continue;
                    string.push(template.substring(j, i));
                    String c = stringC = Character.toString(template.charAt(++i));
                    String p = (String)time_formatPads.get(c);
                    if (p != null) {
                        c = Character.toString(template.charAt(++i));
                    }
                    if ((f = (InternalTimeFormatter)self.timeFormats.get(c)) != null) {
                        c = f.format(dateObj, p == null ? (c.equals("e") ? " " : "0") : p);
                    }
                    string.push(c);
                    j = i + 1;
                }
                string.push(template.substring(j, i));
                return string.join("");
            }
        };
    }

    private static IDate parseImpl(TimeFormat owner, String template, String dateString, boolean isUTC) {
        boolean localZ;
        OMap<String, Integer> d = new OMap<String, Integer>();
        d.put("y", 1900);
        d.put("m", 0);
        d.put("d", 1);
        d.put("H", 0);
        d.put("M", 0);
        d.put("S", 0);
        d.put("L", 0);
        d.put("Z", null);
        int i = owner.timeParse(d, template, dateString, 0);
        if (i != dateString.length()) {
            return null;
        }
        if (d.containsKey("p")) {
            int dH = d.get("H");
            int dP = d.get("p");
            dH = dH % 12 + dP * 12;
            d.remove("H");
            d.put("H", dH);
        }
        boolean bl = localZ = d.get("Z") != null && !isUTC;
        IDate date = ObjectConverter.toBoolean(localZ) ? new DateUTC(0L) : (isUTC ? new DateUTC(0L) : new Date());
        if (d.containsKey("j")) {
            date.setFullYear(d.get("y"), 0, d.get("j"));
        } else if (d.containsKey("w") && (d.containsKey("W") || d.containsKey("U"))) {
            date.setFullYear(d.get("y"), 0, 1);
            int day = d.containsKey("W") ? (d.get("w") + 6) % 7 + d.get("W") * 7 - (date.getDay() + 5) % 7 : d.get("w") + d.get("U") * 7 - (date.getDay() + 6) % 7;
            date.setFullYear(d.get("y"), 0, day);
        } else {
            date.setFullYear(d.get("y"), d.get("m"), d.get("d"));
        }
        if (d.get("Z") == null) {
            date.setHours(d.get("H") + 0, d.get("M") + 0, d.get("S"), d.get("L"));
        } else {
            date.setHours(d.get("H") + (d.get("Z") / 100 | 0), d.get("M") + d.get("Z") % 100, d.get("S"), d.get("L"));
        }
        if (ObjectConverter.toBoolean(localZ)) {
            return new Date(date.getTime());
        }
        if (isUTC) {
            return new Date(date.getTime());
        }
        return date;
    }

    public int timeParse(OMap<String, Integer> d, String template, String str, int j) {
        int _j = j;
        int i = 0;
        int n = template.length();
        int m = str.length();
        while (i < n) {
            int c;
            if (_j >= m) {
                return -1;
            }
            if ((c = Character.codePointAt(template, i++)) == 37) {
                char cc;
                String t;
                String pString = time_formatPads.containsKey(t = Character.toString(cc = template.charAt(i++))) ? Character.toString(template.charAt(i++)) : t;
                TimeParsesValueFunction p = this.getTimeParsers().get(pString);
                _j = p.timeparsers(d, str, _j);
                if (ObjectConverter.toBoolean(pString) && _j >= 0) continue;
                return -1;
            }
            if (c == Character.codePointAt(str, _j++)) continue;
            return -1;
        }
        return _j;
    }

    private void setTimePeriodLookup() {
        if (this.locale.periods != null) {
            for (int i = 0; i < this.locale.periods.length; ++i) {
                this.time_periodLookup.set(this.locale.periods[i].toLowerCase(), i);
            }
        }
    }

    private static OMap<String, String> initialize_time_formatPads() {
        OMap<String, String> time_formatPads = new OMap<String, String>();
        time_formatPads.put("-", "");
        time_formatPads.put("_", " ");
        time_formatPads.put("0", "0");
        return time_formatPads;
    }

    private static String time_formatPad(int value, String fill, int width) {
        String sign = value < 0 ? "-" : "";
        String string = (!sign.isEmpty() && !sign.equals("") ? -value : value) + "";
        int length = string.length();
        return sign + (length < width ? new ArrayEx(width - length + 1).join(fill) + string : string);
    }

    private static String time_zone(IDate date) {
        int z = date.getTimezoneOffset();
        String zs = z > 0 ? "-" : "+";
        int zh = Math.abs(z) / 60 | 0;
        int zm = Math.abs(z) % 60;
        return zs + TimeFormat.time_formatPad(zh, "0", 2) + TimeFormat.time_formatPad(zm, "0", 2);
    }

    private static int time_expandYear(int d) {
        return d + (d > 68 ? 1900 : 2000);
    }

    private static RegExp time_formatRe(String[] names) {
        return new RegExp("^(?:" + TimeFormat.map(names) + ")", "i");
    }

    private static String map(String[] names) {
        ArrayEx<String> maps = new ArrayEx<String>();
        if (ObjectConverter.toBoolean(names)) {
            for (int i = 0; i < names.length; ++i) {
                maps.add(Requote.requote(names[i]));
            }
        }
        return maps.join("|");
    }

    private static ES6Map<String, Integer> time_formatLookup(String[] names) {
        ES6Map<String, Integer> map = ES6Map.create();
        if (ObjectConverter.toBoolean(names)) {
            int i = -1;
            int n = names.length;
            while (++i < n) {
                map.set(names[i].toLowerCase(), i);
            }
        }
        return map;
    }

    private TimeFormatSpecifier createUTC() {
        final TimeFormat self = this;
        return new TimeFormatSpecifier(){

            @Override
            public TimeFormatter create(final String template) {
                final TimeFormatter local = self.create(template);
                return new TimeFormatter(){

                    @Override
                    public IDate parse(String dateString) {
                        return TimeFormat.parseImpl(self, template, dateString, true);
                    }

                    @Override
                    public String toString() {
                        return template;
                    }

                    @Override
                    public String getValue(Object context, Object date, int index, int groupIndex) {
                        return (String)local.getValue(context, new DateUTC(ObjectConverter.toDate(date).getTime()), index, groupIndex);
                    }
                };
            }
        };
    }

    private OMap<String, InternalTimeFormatter> buildTimeFormat() {
        OMap<String, InternalTimeFormatter> map = new OMap<String, InternalTimeFormatter>();
        final TimeFormat self = this;
        map.put("a", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return ((TimeFormat)self).locale.shortDays[date.getDay()];
            }
        });
        map.put("A", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return ((TimeFormat)self).locale.days[date.getDay()];
            }
        });
        map.put("b", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return ((TimeFormat)self).locale.shortMonths[date.getMonth()];
            }
        });
        map.put("B", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return ((TimeFormat)self).locale.months[date.getMonth()];
            }
        });
        map.put("c", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return (String)self.create(((TimeFormat)self).locale.dateTime).getValue(null, date, 0, 0);
            }

            public String toString() {
                return self.create(((TimeFormat)self).locale.dateTime).toString();
            }
        });
        map.put("d", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getDate(), str, 2);
            }
        });
        map.put("e", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getDate(), str, 2);
            }
        });
        map.put("H", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getHours(), str, 2);
            }
        });
        map.put("I", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                if (date.getHours() % 12 > 0) {
                    return TimeFormat.time_formatPad(date.getHours() % 12, str, 2);
                }
                return TimeFormat.time_formatPad(12, str, 2);
            }
        });
        map.put("j", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(1 + Time.getInstance().dayOfYear(date), str, 3);
            }
        });
        map.put("L", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getMilliseconds(), str, 3);
            }
        });
        map.put("m", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getMonth() + 1, str, 2);
            }
        });
        map.put("M", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getMinutes(), str, 2);
            }
        });
        map.put("p", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                int isPM = 0;
                if (date.getHours() >= 12) {
                    isPM = 1;
                }
                return ((TimeFormat)self).locale.periods[isPM];
            }
        });
        map.put("S", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getSeconds(), str, 2);
            }
        });
        map.put("U", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(Time.getInstance().sundayOfYear.get(date), str, 2);
            }
        });
        map.put("w", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return ObjectConverter.toString(date.getDay());
            }
        });
        map.put("W", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(Time.getInstance().mondayOfYear.get(date), str, 2);
            }
        });
        map.put("x", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return (String)self.create(((TimeFormat)self).locale.date).getValue(null, date, 0, 0);
            }

            public String toString() {
                return self.create(((TimeFormat)self).locale.date).toString();
            }
        });
        map.put("X", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return (String)self.create(((TimeFormat)self).locale.time).getValue(null, date, 0, 0);
            }

            public String toString() {
                return self.create(((TimeFormat)self).locale.time).toString();
            }
        });
        map.put("y", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getFullYear() % 100, str, 2);
            }
        });
        map.put("Y", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_formatPad(date.getFullYear() % 10000, str, 4);
            }
        });
        map.put("Z", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return TimeFormat.time_zone(date);
            }
        });
        map.put("%", new InternalTimeFormatter(){

            @Override
            public String format(IDate date, String str) {
                return "%";
            }
        });
        return map;
    }

    private OMap<String, TimeParsesValueFunction> buildTimeParser() {
        final TimeFormat self = this;
        final RegExp time_numberRe = new RegExp("^\\s*\\d+", "");
        final RegExp time_percentRe = new RegExp("^%", "");
        OMap<String, TimeParsesValueFunction> map = new OMap<String, TimeParsesValueFunction>();
        map.put("a", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                ES6Map time_dayAbbrevLookup = TimeFormat.time_formatLookup(((TimeFormat)self).locale.shortDays);
                RegExp time_dayAbbrevRe = TimeFormat.time_formatRe(((TimeFormat)self).locale.shortDays);
                time_dayAbbrevRe.lastIndex = 0;
                RegExp.RegExpResult n = time_dayAbbrevRe.exec(str.substring(i));
                if (n != null) {
                    date.put("w", (Integer)time_dayAbbrevLookup.get(((String)n.get(0)).toLowerCase()));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("A", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                RegExp time_dayRe = TimeFormat.time_formatRe(((TimeFormat)self).locale.days);
                ES6Map time_dayLookup = TimeFormat.time_formatLookup(((TimeFormat)self).locale.days);
                time_dayRe.lastIndex = 0;
                RegExp.RegExpResult n = time_dayRe.exec(str.substring(i));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("w", (Integer)time_dayLookup.get(((String)n.get(0)).toLowerCase()));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("b", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                ES6Map time_monthAbbrevLookup = TimeFormat.time_formatLookup(((TimeFormat)self).locale.shortMonths);
                RegExp time_monthAbbrevRe = TimeFormat.time_formatRe(((TimeFormat)self).locale.shortMonths);
                time_monthAbbrevRe.lastIndex = 0;
                RegExp.RegExpResult n = time_monthAbbrevRe.exec(str.substring(i));
                if (n != null) {
                    date.put("m", (Integer)time_monthAbbrevLookup.get(((String)n.get(0)).toLowerCase()));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("B", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                ES6Map time_monthLookup = TimeFormat.time_formatLookup(((TimeFormat)self).locale.months);
                RegExp time_monthRe = TimeFormat.time_formatRe(((TimeFormat)self).locale.months);
                time_monthRe.lastIndex = 0;
                RegExp.RegExpResult n = time_monthRe.exec(str.substring(i));
                if (n != null) {
                    date.put("m", (Integer)time_monthLookup.get(((String)n.get(0)).toLowerCase()));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("c", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                return self.timeParse(date, ((InternalTimeFormatter)self.timeFormats.get("c")).toString(), str, i);
            }
        });
        map.put("d", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("d", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("e", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(str.substring(i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("d", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("H", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("H", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("I", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("H", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("j", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 3));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("j", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("L", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 3));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("L", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("m", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("m", (int)ObjectConverter.toDouble(n.get(0)) - 1);
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("M", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("M", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("p", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                int _i;
                Integer n = (Integer)self.time_periodLookup.get(str.substring(_i = i, _i += 2).toLowerCase());
                if (n == null) {
                    return -1;
                }
                date.put("p", n);
                return _i;
            }
        });
        map.put("S", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("S", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("U", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(str.substring(i));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("U", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("w", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(str.substring(i, i + 1));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("w", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("W", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(str.substring(i));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("W", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("x", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                return self.timeParse(date, ((InternalTimeFormatter)self.timeFormats.get("x")).toString(), str, i);
            }
        });
        map.put("X", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                return self.timeParse(date, ((InternalTimeFormatter)self.timeFormats.get("X")).toString(), str, i);
            }
        });
        map.put("y", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(Lang.substring(str, i, i + 2));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("y", TimeFormat.time_expandYear((int)ObjectConverter.toDouble(n.get(0))));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("Y", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_numberRe.lastIndex = 0;
                RegExp.RegExpResult n = time_numberRe.exec(str.substring(i, i + 4));
                if (ObjectConverter.toBoolean(n)) {
                    date.put("y", (int)ObjectConverter.toDouble(n.get(0)));
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        map.put("Z", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                String _str = str;
                RegExp regExpStr = new RegExp("^[+-]\\d{4}$", "");
                if (ObjectConverter.toBoolean(regExpStr.test(_str = _str.substring(i, i + 5)))) {
                    date.put("Z", -((int)ObjectConverter.toDouble(_str)));
                    return i + 5;
                }
                return -1;
            }
        });
        map.put("%", new TimeParsesValueFunction(){

            @Override
            public int timeparsers(OMap<String, Integer> date, String str, int i) {
                time_percentRe.lastIndex = 0;
                RegExp.RegExpResult n = time_percentRe.exec(str.substring(i, i + 1));
                if (ObjectConverter.toBoolean(n)) {
                    return i + ((String)n.get(0)).length();
                }
                return -1;
            }
        });
        return map;
    }

    @FunctionClass(value="format")
    @SwiftClosure(value="format")
    private static interface InternalTimeFormatter {
        public String format(IDate var1, String var2);
    }

    @FunctionClass(value="timeparsers", contextInvocation=false)
    @SwiftClosure(value="timeparsers")
    private static interface TimeParsesValueFunction {
        public int timeparsers(OMap<String, Integer> var1, String var2, int var3);
    }

    @FunctionClass(value="timeParse", contextInvocation=false)
    @SwiftClosure(value="timeParse")
    private static interface TimeParseValueFunction {
        public int timeParse(OMap<String, Integer> var1, String var2, String var3, int var4);
    }

    private static class TimeFormatParsers {
        @SwiftWeak
        final TimeFormat timeFormat;
        final OMap<String, TimeParsesValueFunction> timeParsers;

        TimeFormatParsers(TimeFormat timeFormat) {
            this.timeFormat = timeFormat;
            this.timeParsers = timeFormat.buildTimeParser();
        }
    }
}

