/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.dsv;

import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.dsv.Dsv;
import com.ibm.vida.rave.core.nativeImpl.xhr.Xhr;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrResult;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrText;

class DsvInstance<A> {
    int N;
    int I;
    int n;
    boolean eol;
    String EOL = "\n";
    String text;
    char delimiterCode;
    ArrayEx<String> headerRow;

    DsvInstance(String delimiter) {
        this.delimiterCode = delimiter.charAt(0);
    }

    void loadUrl(String url, final Dsv.Response<A, JSONObject> respFunc, final Dsv.Callback<A> dsvCallback) {
        final DsvInstance self = this;
        XhrText.INSTANCE.create(url, new Xhr.Callback<String>(){

            @Override
            public void callback(XhrResult error, String dsvTxt) {
                if (error != null) {
                    dsvCallback.callback(null);
                } else {
                    dsvCallback.callback(self.parse(dsvTxt, respFunc));
                }
            }
        });
    }

    void loadUrl(String url, final Dsv.Callback<JSONObject> dsvCallback) {
        final DsvInstance self = this;
        XhrText.INSTANCE.create(url, new Xhr.Callback<String>(){

            @Override
            public void callback(XhrResult error, String dsvTxt) {
                if (error != null) {
                    dsvCallback.callback(null);
                } else {
                    dsvCallback.callback(self.parse(dsvTxt));
                }
            }
        });
    }

    ArrayEx<A> parse(String fileContent, final Dsv.Response<A, JSONObject> userResponse) {
        final DsvInstance self = this;
        this.headerRow = null;
        Dsv.Response response = new Dsv.Response<A, ArrayEx<String>>(){

            @Override
            public A response(ArrayEx<String> row, int index) {
                if (self.headerRow == null) {
                    self.headerRow = row;
                    return null;
                }
                ArrayEx<String> rowStrings = row;
                int max = self.headerRow.length() >= rowStrings.length() ? rowStrings.length() : self.headerRow.length();
                JSONObject mappedRow = new JSONObject();
                for (int i = 0; i < max; ++i) {
                    mappedRow.put(self.headerRow.get(i), rowStrings.get(i));
                }
                return userResponse.response(mappedRow, index);
            }
        };
        return this.parseRows(fileContent, response);
    }

    ArrayEx<JSONObject> parse(String fileContent) {
        final DsvInstance self = this;
        this.headerRow = null;
        Dsv.Response<JSONObject, ArrayEx<String>> response = new Dsv.Response<JSONObject, ArrayEx<String>>(){

            @Override
            public JSONObject response(ArrayEx<String> row, int index) {
                if (self.headerRow == null) {
                    self.headerRow = row;
                    return null;
                }
                ArrayEx<String> rowStrings = row;
                int max = self.headerRow.length() >= rowStrings.length() ? rowStrings.length() : self.headerRow.length();
                JSONObject mappedRow = new JSONObject();
                for (int i = 0; i < max; ++i) {
                    String value = (String)rowStrings.get(i);
                    if (value == null || value.length() <= 0) continue;
                    mappedRow.put(self.headerRow.get(i), rowStrings.get(i));
                }
                return mappedRow;
            }
        };
        return this.parseRowsNoConversion(fileContent, response);
    }

    ArrayEx<A> parseRows(String fileContent, Dsv.Response<A, ArrayEx<String>> resp) {
        this.N = fileContent.length();
        this.I = 0;
        this.n = 0;
        this.text = fileContent;
        ArrayEx<Object> rows = new ArrayEx<Object>();
        String t = this.token();
        while (t != null) {
            ArrayEx<String> a = new ArrayEx<String>();
            while (t != null && !this.EOL.equals(t)) {
                a.push(t);
                t = this.token();
            }
            Object row = null;
            A a2 = resp.response(a, this.n++);
            row = a2;
            if (a2 != null) {
                rows.push(row);
            }
            t = this.token();
        }
        return rows;
    }

    ArrayEx<ArrayEx<String>> parseRows(String fileContent) {
        this.N = fileContent.length();
        this.I = 0;
        this.n = 0;
        this.text = fileContent;
        ArrayEx<ArrayEx<String>> rows = new ArrayEx<ArrayEx<String>>();
        String t = this.token();
        while (t != null) {
            ArrayEx<String> a = new ArrayEx<String>();
            while (t != null && !this.EOL.equals(t)) {
                a.push(t);
                t = this.token();
            }
            rows.push(a);
            t = this.token();
        }
        return rows;
    }

    private ArrayEx<JSONObject> parseRowsNoConversion(String fileContent, Dsv.Response<JSONObject, ArrayEx<String>> resp) {
        String t;
        this.N = fileContent.length();
        this.I = 0;
        this.n = 0;
        this.text = fileContent;
        ArrayEx<JSONObject> rows = new ArrayEx<JSONObject>();
        while ((t = this.token()) != null) {
            ArrayEx<String> a = new ArrayEx<String>();
            while (t != null && !this.EOL.equals(t)) {
                a.push(t);
                t = this.token();
            }
            JSONObject row = null;
            if ((row = resp.response(a, this.n++)) == null) continue;
            rows.push((JSONObject[])new JSONObject[]{row});
        }
        return rows;
    }

    private String token() {
        if (this.I >= this.N) {
            return null;
        }
        if (this.eol) {
            this.eol = false;
            return this.EOL;
        }
        int j = this.I;
        if (this.text.charAt(j) == '\"') {
            int i = j;
            while (i++ < this.N) {
                if (this.text.charAt(i) != '\"') continue;
                if (i + 1 >= this.N || this.text.charAt(i + 1) != '\"') break;
                ++i;
            }
            this.I = i + 2;
            if (this.I > this.N) {
                this.eol = true;
            } else {
                char c = this.text.charAt(i + 1);
                if (c == '\r') {
                    this.eol = true;
                    if (this.text.charAt(i + 2) == '\n') {
                        ++this.I;
                    }
                } else if (c == '\n') {
                    this.eol = true;
                }
            }
            return this.text.substring(j + 1, i).replaceAll("\"\"", "\\\"");
        }
        while (this.I < this.N) {
            char c = this.text.charAt(this.I++);
            int k = 1;
            if (c == '\n') {
                this.eol = true;
            } else if (c == '\r') {
                this.eol = true;
                if (this.text.charAt(this.I) == '\n') {
                    ++this.I;
                    ++k;
                }
            } else if (c != this.delimiterCode) continue;
            return this.text.substring(j, this.I - k);
        }
        return this.text.substring(j);
    }
}

