/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.event;

import com.ibm.vida.rave.core.event.BaseEvent;
import com.ibm.vida.rave.core.event.Touch;
import com.ibm.vida.rave.core.event.TouchEvent;
import com.ibm.vida.rave.core.event.UIEvent;
import com.ibm.vida.rave.core.geom.NodeRect;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.nativeImpl.event.EventTracker;
import com.ibm.vida.rave.core.scene.SceneNode;

public final class Mouse {
    private Mouse() {
    }

    public static Point mousePoint(SceneNode container) {
        BaseEvent<?> e = EventTracker.INSTANCE.eventSource();
        if (e instanceof TouchEvent) {
            return Mouse.mousePoint(container, (TouchEvent)e);
        }
        if (e instanceof UIEvent) {
            return Mouse.mousePoint(container, (UIEvent)e);
        }
        return null;
    }

    public static Point mousePoint(SceneNode container, UIEvent e) {
        if (e != null) {
            NodeRect rect = container.getBoundingClientRect();
            return new Point(e.clientX - rect.left, e.clientY - rect.top);
        }
        return null;
    }

    public static Point mousePoint(SceneNode container, Touch e) {
        if (e != null) {
            NodeRect rect = container.getBoundingClientRect();
            return new Point(e.clientX - rect.left, e.clientY - rect.top);
        }
        return null;
    }

    public static Point mousePoint(SceneNode container, TouchEvent e) {
        if (e != null && e.changedTouches.size() > 0) {
            Touch t = e.changedTouches.item(0);
            NodeRect rect = container.getBoundingClientRect();
            return new Point(t.clientX - rect.left, t.clientY - rect.top);
        }
        return null;
    }
}

