/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.graphicUtils;

import com.ibm.vida.rave.core.color.Colors;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.graphicUtils.TextMetrics;
import com.ibm.vida.rave.core.nativeImpl.graphicUtils.ImageData;
import com.ibm.vida.rave.core.nativeImpl.graphicUtils.RenderingFontUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class RenderingContext {
    private static final String DEFAULT_FONT = "normal normal normal 10px/normal 'sans-serif'";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String CENTER = "center";
    public static final String START = "start";
    public static final String END = "end";
    private static final Map<String, Integer> _align = new HashMap<String, Integer>();
    private static final Color _clear = new Color(0, 0, 0, 0);
    public String font = "normal normal normal 10px/normal 'sans-serif'";
    private String __font;
    public String strokeStyle = "black";
    public String fillStyle = "red";
    public String textAlign = "left";
    public int lineWidth = 1;
    private FontMetrics _metrics;
    private Graphics2D _graphics;
    private BufferedImage _image;
    private final Queue<State> _history = new ConcurrentLinkedQueue<State>();

    public RenderingContext(double width, double height) {
        this._image = new BufferedImage((int)width, (int)height, 6);
        this._graphics = this._image.createGraphics();
    }

    FontMetrics getFontMetrics() {
        if (this.font != null && !this.font.equals(this.__font)) {
            this._metrics = this._graphics.getFontMetrics(RenderingFontUtils.findFontFromCSS(this.font));
            this.__font = this.font;
        }
        return this._metrics;
    }

    int getAlignment() {
        return _align.get(this.textAlign);
    }

    public TextMetrics measureText(String text) {
        TextMetrics metrics = new TextMetrics();
        FontMetrics fontMetrics = this.getFontMetrics();
        metrics.width = fontMetrics.stringWidth(text);
        metrics.actualBoundingBoxAscent = fontMetrics.getAscent();
        metrics.actualBoundingBoxDescent = fontMetrics.getDescent();
        return metrics;
    }

    public ImageData getImageData(double x, double y, double width, double height) {
        Raster raster = this._image.getData(new Rectangle((int)x, (int)y, (int)width, (int)height));
        ImageData imageData = new ImageData();
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        imageData.data = buffer.getData();
        imageData.width = width;
        imageData.height = height;
        return imageData;
    }

    public void save() {
        State context = new State();
        context.font = this.font;
        context.fillStyle = this.fillStyle;
        context.lineWidth = this.lineWidth;
        context.strokeStyle = this.strokeStyle;
        context.textAlign = this.textAlign;
        context.transform = this._graphics.getTransform();
        this._history.add(context);
    }

    public void clearRect(double x, double y, double width, double height) {
        this._graphics.setBackground(_clear);
        this._graphics.clearRect((int)x, (int)y, (int)width, (int)height);
    }

    public void translate(double x, double y) {
        this._graphics.translate((int)x, (int)y);
    }

    public void rotate(double theta) {
        this._graphics.rotate(theta);
    }

    public void fillText(String text, int x, int y) {
        if (text == null || text.length() == 0) {
            return;
        }
        FontMetrics metrics = this.getFontMetrics();
        switch (this.getAlignment()) {
            case 1: {
                x -= metrics.stringWidth(text) / 2;
                break;
            }
            case 2: {
                x -= metrics.stringWidth(text);
            }
        }
        Font awtFont = metrics.getFont();
        double scale = (awtFont.getSize2D() + (float)(2 * this.lineWidth)) / awtFont.getSize2D();
        AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
        transform.translate((double)x / scale, (double)y / scale);
        TextLayout textLayout = new TextLayout(text, awtFont, this._graphics.getFontRenderContext());
        Shape outline = textLayout.getOutline(transform);
        BasicStroke stroke = new BasicStroke(this.lineWidth);
        this._graphics.setStroke(stroke);
        RGB rgb = Colors.newRGB(this.fillStyle);
        this._graphics.setColor(new Color(rgb.getR(), rgb.getG(), rgb.getB()));
        this._graphics.fill(outline);
    }

    public void strokeText(String text, int x, int y) {
        FontMetrics metrics = this.getFontMetrics();
        switch (this.getAlignment()) {
            case 1: {
                x -= metrics.stringWidth(text) / 2;
                break;
            }
            case 2: {
                x -= metrics.stringWidth(text);
            }
        }
        Font awtFont = metrics.getFont();
        double scale = (awtFont.getSize2D() + (float)(2 * this.lineWidth)) / awtFont.getSize2D();
        AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
        transform.translate((double)x / scale, (double)y / scale);
        TextLayout textLayout = new TextLayout(text, awtFont, this._graphics.getFontRenderContext());
        Shape outline = textLayout.getOutline(transform);
        BasicStroke stroke = new BasicStroke(this.lineWidth);
        this._graphics.setStroke(stroke);
        RGB rgb = Colors.newRGB(this.strokeStyle);
        this._graphics.setColor(new Color(rgb.getR(), rgb.getG(), rgb.getB()));
        this._graphics.draw(outline);
    }

    public void restore() {
        State context = this._history.remove();
        if (context != null) {
            this.__font = this.font = context.font;
            this.textAlign = context.textAlign;
            this.fillStyle = context.fillStyle;
            this.lineWidth = context.lineWidth;
            this.strokeStyle = context.strokeStyle;
            this._graphics.setTransform(context.transform);
        }
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    public BufferedImage getImage() {
        return this._image;
    }

    public void dispose() {
        if (this._graphics != null) {
            this._graphics.dispose();
            this._graphics = null;
            this._image = null;
        }
    }

    static {
        _align.put(CENTER, 1);
        _align.put(LEFT, 0);
        _align.put(RIGHT, 2);
        _align.put(END, 2);
        _align.put(START, 0);
    }

    private static class State {
        String font;
        String strokeStyle;
        String fillStyle;
        String textAlign;
        AffineTransform transform;
        int lineWidth;

        private State() {
        }
    }
}

