/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.graphicUtils;

import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.css.CSSUnit;
import com.ibm.vida.rave.core.internal.css.CSSUtil;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import java.awt.Font;

public class RenderingFontUtils {
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);

    public static final Font findFont(String family, String style, String weight, CSSSize size) {
        String[] families;
        int jstyle = 0;
        if ("italic".equals(style) || "oblique".equals(style)) {
            jstyle = 2;
        }
        if ("bold".equals(weight) || "bolder".equals(weight) || ObjectConverter.toDouble(weight) > 600.0) {
            ++jstyle;
        }
        double sizeValue = 10.0;
        CSSUnit sizeUnit = CSSUnit.UNIT_PX;
        if (size != null) {
            sizeValue = size.value;
            sizeUnit = size.unit;
        }
        if (sizeUnit == CSSUnit.UNIT_PT) {
            sizeValue *= 1.3333333333333333;
        } else if (sizeUnit == CSSUnit.UNIT_PC) {
            sizeValue *= 16.0;
        } else if (sizeUnit == CSSUnit.UNIT_IN) {
            sizeValue *= 96.0;
        } else if (sizeUnit == CSSUnit.UNIT_MM) {
            sizeValue *= 3.7795275590551185;
        } else if (sizeUnit == CSSUnit.UNIT_CM) {
            sizeValue *= 37.79527559055118;
        }
        int jsize = (int)sizeValue;
        for (String f : families = family == null ? new String[]{} : family.split(",")) {
            if ("sans-serif".equals(f = f.trim().replaceAll("\"|'", ""))) {
                f = "SansSerif";
            } else if ("serif".equals(f)) {
                f = "Serif";
            } else if ("monospaced".equals(f)) {
                f = "Monospaced";
            }
            Font font = new Font(f, jstyle, jsize);
            if (!"Dialog".equals(f) && "Dialog".equals(font.getFamily())) continue;
            return font;
        }
        return new Font("SansSerif", jstyle, jsize);
    }

    public static final Font findFontFromCSS(String css) {
        String[] parsed = CSSUtil.parseFont(css);
        if (parsed[3] == null || parsed[5] == null) {
            return DEFAULT_FONT;
        }
        return RenderingFontUtils.findFont(parsed[5], parsed[0], parsed[2], CSSUtil.parseSize(parsed[3]));
    }
}

