/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.interpolate;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.interpolate.Interpolator;
import com.ibm.vida.rave.core.interpolate.InterpolatorFactory;
import com.ibm.vida.rave.core.interpolate.Interpolators;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectInterpolation
implements InterpolatorFactory<Object> {
    public static final ObjectInterpolation INSTANCE = new ObjectInterpolation();

    @Override
    public final Interpolator<Object> create(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        if (b instanceof JSONArray && !(a instanceof JSONArray)) {
            return null;
        }
        if (b instanceof JSONObject) {
            if (a instanceof JSONObject) {
                return this.interpolateJSONObject((JSONObject)a, (JSONObject)b);
            }
            return null;
        }
        if (b instanceof List) {
            return this.interpolateList((List)a, (List)b);
        }
        final Object c = ObjectInterpolation.createObjectTemplate(b);
        Field[] fieldsb = b.getClass().getFields();
        final Map<String, Interpolator<?>> interpolators = ObjectInterpolation.createInterpolators(a, b, c, fieldsb);
        return new Interpolator<Object>(){

            @Override
            public Object interpolate(double t) {
                Set keys = interpolators.keySet();
                for (String fieldName : keys) {
                    try {
                        Field field = c.getClass().getField(fieldName);
                        field.set(c, ((Interpolator)interpolators.get(fieldName)).interpolate(t));
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                return c;
            }
        };
    }

    private final Interpolator<Object> interpolateJSONObject(JSONObject a, JSONObject b) {
        final HashMap interpolators = new HashMap();
        final JSONObject c = new JSONObject();
        for (Object key : b.keySet()) {
            Object av = a.get(key);
            if (av != null) {
                interpolators.put(key, this.jsonInterpolator(av, b.get(key)));
                continue;
            }
            c.put(key, b.get(key));
        }
        for (Object key : a.keySet()) {
            if (b.get(key) != null) continue;
            c.put(key, a.get(key));
        }
        return new Interpolator<Object>(){

            @Override
            public Object interpolate(double t) {
                Set keys = interpolators.keySet();
                for (Object key : keys) {
                    c.put(key, ((Interpolator)interpolators.get(key)).interpolate(t));
                }
                return c;
            }
        };
    }

    private final Interpolator<Object> interpolateJSONArray(JSONArray a, JSONArray b) {
        int i;
        int nb;
        int na = a.size();
        final int n0 = na < (nb = b.size()) ? na : nb;
        final Interpolator[] interpolators = new Interpolator[n0];
        final JSONArray c = new JSONArray();
        for (i = 0; i < n0; ++i) {
            interpolators[i] = this.jsonInterpolator(a.get(i), b.get(i));
            c.add(null);
        }
        while (i < na) {
            c.add(a.get(i));
            ++i;
        }
        while (i < nb) {
            c.add(b.get(i));
            ++i;
        }
        return new Interpolator<Object>(){

            @Override
            public Object interpolate(double t) {
                for (int i = 0; i < n0; ++i) {
                    c.set(i, interpolators[i].interpolate(t));
                }
                return c;
            }
        };
    }

    private final Interpolator<?> jsonInterpolator(Object a, Object b) {
        if (b instanceof JSONObject) {
            return this.interpolateJSONObject((JSONObject)a, (JSONObject)b);
        }
        if (b instanceof JSONArray) {
            return this.interpolateJSONArray((JSONArray)a, (JSONArray)b);
        }
        return Interpolators.INSTANCE.getInterpolator(a, b);
    }

    private final Interpolator<Object> interpolateList(List<Object> a, List<Object> b) {
        int i;
        int nb;
        int na = a.size();
        final int n0 = na < (nb = b.size()) ? na : nb;
        int N = na > nb ? na : nb;
        final Interpolator[] interpolators = new Interpolator[n0];
        final List c = (List)ObjectInterpolation.createObjectTemplate(b);
        for (i = 0; i < n0; ++i) {
            interpolators[i] = Interpolators.INSTANCE.getInterpolator(a.get(i), b.get(i));
            c.add(null);
        }
        while (i < na) {
            c.add(a.get(i));
            ++i;
        }
        while (i < nb) {
            c.add(b.get(i));
            ++i;
        }
        return new Interpolator<Object>(){

            @Override
            public Object interpolate(double t) {
                for (int i = 0; i < n0; ++i) {
                    c.set(i, interpolators[i].interpolate(t));
                }
                return c;
            }
        };
    }

    private static Map<String, Interpolator<?>> createInterpolators(Object a, Object b, Object template, Field[] fieldsb) {
        HashMap interpolators = new HashMap();
        for (int index = 0; index < fieldsb.length; ++index) {
            Field fieldb = fieldsb[index];
            String fieldName = fieldb.getName();
            Field fielda = null;
            try {
                fielda = a.getClass().getField(fieldName);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            Object valuea = null;
            Object valueb = null;
            try {
                valueb = fieldb.get(b);
                if (fielda != null) {
                    valuea = fielda.get(a);
                    Interpolator<?> i = Interpolators.INSTANCE.getInterpolator(valuea, valueb);
                    if (i == null) continue;
                    interpolators.put(fieldName, i);
                    continue;
                }
                fieldb.set(template, valueb);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return interpolators;
    }

    private static Object createObjectTemplate(Object object) {
        Object template = null;
        if (object != null) {
            Class<?> clazz = object.getClass();
            try {
                template = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return template;
    }
}

