/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.nativeImpl.time;

import com.ibm.vida.rave.core.nativeImpl.time.DateUtil;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.core.time.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class Date
implements IDate {
    private final Calendar date;
    private static final TimeZone LOCAL_TIMEZONE = TimeZone.getDefault();
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    public Date() {
        this.date = Calendar.getInstance(LOCAL_TIMEZONE);
    }

    public Date(long value) {
        this.date = Calendar.getInstance(UTC_TIMEZONE);
        this.date.setTimeInMillis(value);
        this.date.get(11);
    }

    public Date(String dateString) {
        this.date = Calendar.getInstance(UTC_TIMEZONE);
        this.date.setTimeInMillis(Date.parse(dateString));
        this.date.get(11);
    }

    public Date(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this.date = this.getResetLocalTimeCalendarInstance();
        this.date.set(year, month, day, hour, minute, second);
        this.date.set(14, millisecond);
        this.date.getTimeInMillis();
    }

    public Date(int year, int month, int day, int hour, int minute, int second) {
        this.date = this.getResetLocalTimeCalendarInstance();
        this.date.set(year, month, day, hour, minute, second);
        this.date.getTimeInMillis();
    }

    public Date(int year, int month, int day, int hour, int minute) {
        this.date = this.getResetLocalTimeCalendarInstance();
        this.date.set(year, month, day, hour, minute);
        this.date.getTimeInMillis();
    }

    public Date(int year, int month, int day, int hour) {
        this.date = this.getResetLocalTimeCalendarInstance();
        this.date.set(year, month, day, hour, 0);
        this.date.getTimeInMillis();
    }

    public Date(int year, int month, int day) {
        this.date = this.getResetLocalTimeCalendarInstance();
        this.date.set(year, month, day, 0, 0, 0);
        this.date.getTimeInMillis();
    }

    public Date(int year, int month) {
        this.date = this.getResetLocalTimeCalendarInstance();
        this.date.set(year, month, 1);
        this.date.getTimeInMillis();
    }

    private Calendar getResetLocalTimeCalendarInstance() {
        Calendar newDate = Calendar.getInstance(LOCAL_TIMEZONE);
        newDate.setTimeInMillis(0L);
        return newDate;
    }

    public static long now() {
        return new Date().getTime();
    }

    public static long parse(String string) {
        String format = DateUtil.determineDateFormat(string);
        if (format == null) {
            return 0L;
        }
        if (DateUtil.isUTC(string)) {
            return Time.getInstance().format.utc.create(format).parse(string).getTime();
        }
        return Time.getInstance().format.create(format).parse(string).getTime();
    }

    @Override
    public int getDate() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(5);
    }

    @Override
    public int getDay() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(7) - 1;
    }

    @Override
    public int getFullYear() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(1);
    }

    @Override
    public int getHours() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(11);
    }

    @Override
    public int getMilliseconds() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(14);
    }

    @Override
    public int getMinutes() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(12);
    }

    @Override
    public int getMonth() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(2);
    }

    @Override
    public int getSeconds() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return this.date.get(13);
    }

    @Override
    public long getTime() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.getTimeInMillis();
    }

    @Override
    public int getTimezoneOffset() {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        return -(this.date.get(15) + this.date.get(16)) / 60000;
    }

    @Override
    public int getUTCDate() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(5);
    }

    @Override
    public int getUTCDay() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(7) - 1;
    }

    @Override
    public int getUTCFullYear() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(1);
    }

    @Override
    public int getUTCHours() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(11);
    }

    @Override
    public int getUTCMilliseconds() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(14);
    }

    @Override
    public int getUTCMinutes() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(12);
    }

    @Override
    public int getUTCMonth() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(2);
    }

    @Override
    public int getUTCSeconds() {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        return this.date.get(13);
    }

    @Override
    public long setDate(int day) {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        this.date.set(5, day);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setFullYear(int year, int month, int day) {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        this.date.set(year, month, day);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setHours(int hours, int minutes, int seconds, int milliseconds) {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        this.date.set(11, hours);
        this.date.set(12, minutes);
        this.date.set(13, seconds);
        this.date.set(14, milliseconds);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setMilliseconds(int milis) {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        this.date.set(14, milis);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setMinutes(int minutes) {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        this.date.set(12, minutes);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setMonth(int month, int day) {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        this.date.set(2, month);
        this.date.set(5, day);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setSeconds(int seconds) {
        this.adjustCalendarTimeZone(LOCAL_TIMEZONE);
        this.date.set(13, seconds);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setTime(long time) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.setTimeInMillis(time);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setUTCDate(int day) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.set(5, day);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setUTCFullYear(int year, int month, int day) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.set(year, month, day);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setUTCHours(int hours, int minutes, int seconds, int milliseconds) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.set(11, hours);
        this.date.set(12, minutes);
        this.date.set(13, seconds);
        this.date.set(14, milliseconds);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setUTCMilliseconds(int millis) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.set(14, millis);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setUTCMinutes(int minutes) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.set(12, minutes);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setUTCSeconds(int seconds) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.set(13, seconds);
        return this.date.getTimeInMillis();
    }

    @Override
    public long setUTCMonth(int month, int day) {
        this.adjustCalendarTimeZone(UTC_TIMEZONE);
        this.date.set(2, month);
        this.date.set(5, day);
        return this.date.getTimeInMillis();
    }

    public static long UTC(int year, int month) {
        year = Date.yearCenturyCheck(year);
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(0L);
        utc.set(year, month, 1);
        return utc.getTimeInMillis();
    }

    public static long UTC(int year, int month, int day) {
        year = Date.yearCenturyCheck(year);
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(0L);
        utc.set(year, month, day);
        return utc.getTimeInMillis();
    }

    public static long UTC(int year, int month, int day, int hour) {
        year = Date.yearCenturyCheck(year);
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(0L);
        utc.set(year, month, day);
        utc.set(year, month, day, hour, 0);
        return utc.getTimeInMillis();
    }

    public static long UTC(int year, int month, int day, int hour, int minute) {
        year = Date.yearCenturyCheck(year);
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(0L);
        utc.set(year, month, day, hour, minute);
        return utc.getTimeInMillis();
    }

    public static long UTC(int year, int month, int day, int hour, int minute, int second) {
        year = Date.yearCenturyCheck(year);
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(0L);
        utc.set(year, month, day, hour, minute, second);
        return utc.getTimeInMillis();
    }

    public static long UTC(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        year = Date.yearCenturyCheck(year);
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(0L);
        utc.set(year, month, day, hour, minute, second);
        utc.set(14, millisecond);
        return utc.getTimeInMillis();
    }

    private static int yearCenturyCheck(int year) {
        if (0 <= year && year < 100) {
            year += 1900;
        }
        return year;
    }

    @Override
    public IDate getDateObject() {
        return this;
    }

    @Override
    public String toISOString() {
        int ms = this.getUTCMilliseconds();
        String updatedms = (ms < 10 ? "00" : (ms < 100 ? "0" : "")) + ms;
        return this.getUTCFullYear() + "-" + (this.getUTCMonth() + 1) + "-" + this.getUTCDate() + "T" + this.getUTCHours() + ":" + this.getUTCMinutes() + ":" + this.getUTCSeconds() + "." + updatedms + "Z";
    }

    private void adjustCalendarTimeZone(TimeZone timeZone) {
        if (this.date.getTimeZone() != timeZone) {
            this.date.setTimeZone(timeZone);
        }
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d yyyy HH:mm:ss 'GMT'Z (z)");
        return formatter.format(this.date.getTime());
    }
}

